/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import nutanix.model.ProjectReference;
import nutanix.model.UserReference;
import org.joda.time.DateTime;

@ApiModel(description="The vm_nic kind metadata")
public class VmNicMetadata {
    @SerializedName(value="categories")
    private Map<String, String> categories = new HashMap<String, String>();
    @SerializedName(value="creation_time")
    private DateTime creationTime = null;
    @SerializedName(value="kind")
    private String kind = "vm_nic";
    @SerializedName(value="last_update_time")
    private DateTime lastUpdateTime = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner_reference")
    private UserReference ownerReference = null;
    @SerializedName(value="project_reference")
    private ProjectReference projectReference = null;
    @SerializedName(value="spec_version")
    private Integer specVersion = null;
    @SerializedName(value="uuid")
    private String uuid = null;

    public VmNicMetadata categories(Map<String, String> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", value="Categories for the vm_nic")
    public Map<String, String> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, String> categories) {
        this.categories = categories;
    }

    @ApiModelProperty(example="null", value="Time when vm_nic was created")
    public DateTime getCreationTime() {
        return this.creationTime;
    }

    @ApiModelProperty(example="null", required=true, value="The kind name")
    public String getKind() {
        return this.kind;
    }

    @ApiModelProperty(example="null", value="Time when vm_nic was last updated")
    public DateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @ApiModelProperty(example="null", value="vm_nic name")
    public String getName() {
        return this.name;
    }

    public VmNicMetadata ownerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public UserReference getOwnerReference() {
        return this.ownerReference;
    }

    public void setOwnerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
    }

    public VmNicMetadata projectReference(ProjectReference projectReference) {
        this.projectReference = projectReference;
        return this;
    }

    @ApiModelProperty(example="null", value="The project the vm_nic is in.")
    public ProjectReference getProjectReference() {
        return this.projectReference;
    }

    public void setProjectReference(ProjectReference projectReference) {
        this.projectReference = projectReference;
    }

    public VmNicMetadata specVersion(Integer specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Version number of the latest spec")
    public Integer getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(Integer specVersion) {
        this.specVersion = specVersion;
    }

    public VmNicMetadata uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(example="null", value="vm_nic UUID")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmNicMetadata vmNicMetadata = (VmNicMetadata)o;
        return Objects.equals(this.categories, vmNicMetadata.categories) && Objects.equals(this.creationTime, vmNicMetadata.creationTime) && Objects.equals(this.kind, vmNicMetadata.kind) && Objects.equals(this.lastUpdateTime, vmNicMetadata.lastUpdateTime) && Objects.equals(this.name, vmNicMetadata.name) && Objects.equals(this.ownerReference, vmNicMetadata.ownerReference) && Objects.equals(this.projectReference, vmNicMetadata.projectReference) && Objects.equals(this.specVersion, vmNicMetadata.specVersion) && Objects.equals(this.uuid, vmNicMetadata.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.creationTime, this.kind, this.lastUpdateTime, this.name, this.ownerReference, this.projectReference, this.specVersion, this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmNicMetadata {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerReference: ").append(this.toIndentedString(this.ownerReference)).append("\n");
        sb.append("    projectReference: ").append(this.toIndentedString(this.projectReference)).append("\n");
        sb.append("    specVersion: ").append(this.toIndentedString(this.specVersion)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

