/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.IpAddress;
import nutanix.model.NetworkFunctionChainReference;
import nutanix.model.SubnetReference;

@ApiModel(description="Virtual Machine NIC.")
public class VmNic {
    @SerializedName(value="ip_endpoint_list")
    private List<IpAddress> ipEndpointList = new ArrayList<IpAddress>();
    @SerializedName(value="mac_address")
    private String macAddress = null;
    @SerializedName(value="network_function_chain_reference")
    private NetworkFunctionChainReference networkFunctionChainReference = null;
    @SerializedName(value="network_function_nic_type")
    private String networkFunctionNicType = null;
    @SerializedName(value="nic_type")
    private String nicType = null;
    @SerializedName(value="subnet_reference")
    private SubnetReference subnetReference = null;

    public VmNic ipEndpointList(List<IpAddress> ipEndpointList) {
        this.ipEndpointList = ipEndpointList;
        return this;
    }

    @ApiModelProperty(example="null", value="IP endpoints for the adapter. Currently, IPv4 addresses are supported. ")
    public List<IpAddress> getIpEndpointList() {
        return this.ipEndpointList;
    }

    public void setIpEndpointList(List<IpAddress> ipEndpointList) {
        this.ipEndpointList = ipEndpointList;
    }

    public VmNic macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The MAC address for the adapter.")
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public VmNic networkFunctionChainReference(NetworkFunctionChainReference networkFunctionChainReference) {
        this.networkFunctionChainReference = networkFunctionChainReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public NetworkFunctionChainReference getNetworkFunctionChainReference() {
        return this.networkFunctionChainReference;
    }

    public void setNetworkFunctionChainReference(NetworkFunctionChainReference networkFunctionChainReference) {
        this.networkFunctionChainReference = networkFunctionChainReference;
    }

    public VmNic networkFunctionNicType(String networkFunctionNicType) {
        this.networkFunctionNicType = networkFunctionNicType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this Network function NIC. Defaults to INGRESS. ")
    public String getNetworkFunctionNicType() {
        return this.networkFunctionNicType;
    }

    public void setNetworkFunctionNicType(String networkFunctionNicType) {
        this.networkFunctionNicType = networkFunctionNicType;
    }

    public VmNic nicType(String nicType) {
        this.nicType = nicType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this NIC. Defaults to NORMAL_NIC.")
    public String getNicType() {
        return this.nicType;
    }

    public void setNicType(String nicType) {
        this.nicType = nicType;
    }

    public VmNic subnetReference(SubnetReference subnetReference) {
        this.subnetReference = subnetReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public SubnetReference getSubnetReference() {
        return this.subnetReference;
    }

    public void setSubnetReference(SubnetReference subnetReference) {
        this.subnetReference = subnetReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmNic vmNic = (VmNic)o;
        return Objects.equals(this.ipEndpointList, vmNic.ipEndpointList) && Objects.equals(this.macAddress, vmNic.macAddress) && Objects.equals(this.networkFunctionChainReference, vmNic.networkFunctionChainReference) && Objects.equals(this.networkFunctionNicType, vmNic.networkFunctionNicType) && Objects.equals(this.nicType, vmNic.nicType) && Objects.equals(this.subnetReference, vmNic.subnetReference);
    }

    public int hashCode() {
        return Objects.hash(this.ipEndpointList, this.macAddress, this.networkFunctionChainReference, this.networkFunctionNicType, this.nicType, this.subnetReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmNic {\n");
        sb.append("    ipEndpointList: ").append(this.toIndentedString(this.ipEndpointList)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    networkFunctionChainReference: ").append(this.toIndentedString(this.networkFunctionChainReference)).append("\n");
        sb.append("    networkFunctionNicType: ").append(this.toIndentedString(this.networkFunctionNicType)).append("\n");
        sb.append("    nicType: ").append(this.toIndentedString(this.nicType)).append("\n");
        sb.append("    subnetReference: ").append(this.toIndentedString(this.subnetReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

