/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Vm;
import nutanix.model.VmDefStatus;
import nutanix.model.VmMetadata;

@ApiModel(description="Response object for intentful operations on a vm")
public class VmIntentResource {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="metadata")
    private VmMetadata metadata = null;
    @SerializedName(value="spec")
    private Vm spec = null;
    @SerializedName(value="status")
    private VmDefStatus status = null;

    public VmIntentResource apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public VmIntentResource metadata(VmMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public VmMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(VmMetadata metadata) {
        this.metadata = metadata;
    }

    public VmIntentResource spec(Vm spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Vm getSpec() {
        return this.spec;
    }

    public void setSpec(Vm spec) {
        this.spec = spec;
    }

    public VmIntentResource status(VmDefStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmDefStatus getStatus() {
        return this.status;
    }

    public void setStatus(VmDefStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmIntentResource vmIntentResource = (VmIntentResource)o;
        return Objects.equals(this.apiVersion, vmIntentResource.apiVersion) && Objects.equals(this.metadata, vmIntentResource.metadata) && Objects.equals(this.spec, vmIntentResource.spec) && Objects.equals(this.status, vmIntentResource.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmIntentResource {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

