/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Graphics resource status information for the Virtual Machine.")
public class VmGpuOutputStatus {
    @SerializedName(value="device_id")
    private Integer deviceId = null;
    @SerializedName(value="mode")
    private String mode = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="pci_address")
    private String pciAddress = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="vendor")
    private String vendor = null;

    public VmGpuOutputStatus deviceId(Integer deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    @ApiModelProperty(example="null", value="The device ID of the GPU.")
    public Integer getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public VmGpuOutputStatus mode(String mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="The mode of this GPU")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public VmGpuOutputStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the GPU resource.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VmGpuOutputStatus pciAddress(String pciAddress) {
        this.pciAddress = pciAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="GPU {segment:bus:device:function} (sbdf) address if assigned. ")
    public String getPciAddress() {
        return this.pciAddress;
    }

    public void setPciAddress(String pciAddress) {
        this.pciAddress = pciAddress;
    }

    public VmGpuOutputStatus uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public VmGpuOutputStatus vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @ApiModelProperty(example="null", value="The vendor of the GPU.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmGpuOutputStatus vmGpuOutputStatus = (VmGpuOutputStatus)o;
        return Objects.equals(this.deviceId, vmGpuOutputStatus.deviceId) && Objects.equals(this.mode, vmGpuOutputStatus.mode) && Objects.equals(this.name, vmGpuOutputStatus.name) && Objects.equals(this.pciAddress, vmGpuOutputStatus.pciAddress) && Objects.equals(this.uuid, vmGpuOutputStatus.uuid) && Objects.equals(this.vendor, vmGpuOutputStatus.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.mode, this.name, this.pciAddress, this.uuid, this.vendor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmGpuOutputStatus {\n");
        sb.append("    deviceId: ").append(this.toIndentedString(this.deviceId)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pciAddress: ").append(this.toIndentedString(this.pciAddress)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

