/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Reference;
import nutanix.model.VmDiskDeviceProperties;

@ApiModel(description="VirtualMachine Disk (VM Disk).")
public class VmDisk {
    @SerializedName(value="data_source_reference")
    private Reference dataSourceReference = null;
    @SerializedName(value="device_properties")
    private VmDiskDeviceProperties deviceProperties = null;
    @SerializedName(value="disk_size_mib")
    private Integer diskSizeMib = null;
    @SerializedName(value="volume_group_reference")
    private Reference volumeGroupReference = null;

    public VmDisk dataSourceReference(Reference dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getDataSourceReference() {
        return this.dataSourceReference;
    }

    public void setDataSourceReference(Reference dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
    }

    public VmDisk deviceProperties(VmDiskDeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmDiskDeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public void setDeviceProperties(VmDiskDeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
    }

    public VmDisk diskSizeMib(Integer diskSizeMib) {
        this.diskSizeMib = diskSizeMib;
        return this;
    }

    @ApiModelProperty(example="null", value="Size for the disk in MiB.")
    public Integer getDiskSizeMib() {
        return this.diskSizeMib;
    }

    public void setDiskSizeMib(Integer diskSizeMib) {
        this.diskSizeMib = diskSizeMib;
    }

    public VmDisk volumeGroupReference(Reference volumeGroupReference) {
        this.volumeGroupReference = volumeGroupReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getVolumeGroupReference() {
        return this.volumeGroupReference;
    }

    public void setVolumeGroupReference(Reference volumeGroupReference) {
        this.volumeGroupReference = volumeGroupReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmDisk vmDisk = (VmDisk)o;
        return Objects.equals(this.dataSourceReference, vmDisk.dataSourceReference) && Objects.equals(this.deviceProperties, vmDisk.deviceProperties) && Objects.equals(this.diskSizeMib, vmDisk.diskSizeMib) && Objects.equals(this.volumeGroupReference, vmDisk.volumeGroupReference);
    }

    public int hashCode() {
        return Objects.hash(this.dataSourceReference, this.deviceProperties, this.diskSizeMib, this.volumeGroupReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmDisk {\n");
        sb.append("    dataSourceReference: ").append(this.toIndentedString(this.dataSourceReference)).append("\n");
        sb.append("    deviceProperties: ").append(this.toIndentedString(this.deviceProperties)).append("\n");
        sb.append("    diskSizeMib: ").append(this.toIndentedString(this.diskSizeMib)).append("\n");
        sb.append("    volumeGroupReference: ").append(this.toIndentedString(this.volumeGroupReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

