/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.GuestCustomizationStatus;
import nutanix.model.Reference;
import nutanix.model.VmBootConfig;
import nutanix.model.VmDisk;
import nutanix.model.VmGpuOutputStatus;
import nutanix.model.VmNicOutputStatus;
import nutanix.model.VmPowerStateMechanism;

public class VmDefStatusResources {
    @SerializedName(value="boot_config")
    private VmBootConfig bootConfig = null;
    @SerializedName(value="disk_list")
    private List<VmDisk> diskList = new ArrayList<VmDisk>();
    @SerializedName(value="gpu_list")
    private List<VmGpuOutputStatus> gpuList = new ArrayList<VmGpuOutputStatus>();
    @SerializedName(value="guest_customization")
    private GuestCustomizationStatus guestCustomization = null;
    @SerializedName(value="host_reference")
    private Reference hostReference = null;
    @SerializedName(value="hypervisor_type")
    private String hypervisorType = null;
    @SerializedName(value="memory_size_mib")
    private Integer memorySizeMib = null;
    @SerializedName(value="nic_list")
    private List<VmNicOutputStatus> nicList = new ArrayList<VmNicOutputStatus>();
    @SerializedName(value="num_sockets")
    private Integer numSockets = null;
    @SerializedName(value="num_vcpus_per_socket")
    private Integer numVcpusPerSocket = null;
    @SerializedName(value="parent_reference")
    private Reference parentReference = null;
    @SerializedName(value="power_state")
    private String powerState = null;
    @SerializedName(value="power_state_mechanism")
    private VmPowerStateMechanism powerStateMechanism = null;

    public VmDefStatusResources bootConfig(VmBootConfig bootConfig) {
        this.bootConfig = bootConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates which device the VM should boot from.")
    public VmBootConfig getBootConfig() {
        return this.bootConfig;
    }

    public void setBootConfig(VmBootConfig bootConfig) {
        this.bootConfig = bootConfig;
    }

    public VmDefStatusResources diskList(List<VmDisk> diskList) {
        this.diskList = diskList;
        return this;
    }

    @ApiModelProperty(example="null", value="Disks attached to the VM.")
    public List<VmDisk> getDiskList() {
        return this.diskList;
    }

    public void setDiskList(List<VmDisk> diskList) {
        this.diskList = diskList;
    }

    public VmDefStatusResources gpuList(List<VmGpuOutputStatus> gpuList) {
        this.gpuList = gpuList;
        return this;
    }

    @ApiModelProperty(example="null", value="GPUs attached to the VM.")
    public List<VmGpuOutputStatus> getGpuList() {
        return this.gpuList;
    }

    public void setGpuList(List<VmGpuOutputStatus> gpuList) {
        this.gpuList = gpuList;
    }

    public VmDefStatusResources guestCustomization(GuestCustomizationStatus guestCustomization) {
        this.guestCustomization = guestCustomization;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GuestCustomizationStatus getGuestCustomization() {
        return this.guestCustomization;
    }

    public void setGuestCustomization(GuestCustomizationStatus guestCustomization) {
        this.guestCustomization = guestCustomization;
    }

    public VmDefStatusResources hostReference(Reference hostReference) {
        this.hostReference = hostReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getHostReference() {
        return this.hostReference;
    }

    public void setHostReference(Reference hostReference) {
        this.hostReference = hostReference;
    }

    public VmDefStatusResources hypervisorType(String hypervisorType) {
        this.hypervisorType = hypervisorType;
        return this;
    }

    @ApiModelProperty(example="null", value="The hypervisor type for the hypervisor the VM is hosted on. ")
    public String getHypervisorType() {
        return this.hypervisorType;
    }

    public void setHypervisorType(String hypervisorType) {
        this.hypervisorType = hypervisorType;
    }

    public VmDefStatusResources memorySizeMib(Integer memorySizeMib) {
        this.memorySizeMib = memorySizeMib;
        return this;
    }

    @ApiModelProperty(example="null", value="Memory size in MiB.")
    public Integer getMemorySizeMib() {
        return this.memorySizeMib;
    }

    public void setMemorySizeMib(Integer memorySizeMib) {
        this.memorySizeMib = memorySizeMib;
    }

    public VmDefStatusResources nicList(List<VmNicOutputStatus> nicList) {
        this.nicList = nicList;
        return this;
    }

    @ApiModelProperty(example="null", value="NICs attached to the VM.")
    public List<VmNicOutputStatus> getNicList() {
        return this.nicList;
    }

    public void setNicList(List<VmNicOutputStatus> nicList) {
        this.nicList = nicList;
    }

    public VmDefStatusResources numSockets(Integer numSockets) {
        this.numSockets = numSockets;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of vCPU sockets.")
    public Integer getNumSockets() {
        return this.numSockets;
    }

    public void setNumSockets(Integer numSockets) {
        this.numSockets = numSockets;
    }

    public VmDefStatusResources numVcpusPerSocket(Integer numVcpusPerSocket) {
        this.numVcpusPerSocket = numVcpusPerSocket;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of vCPUs per socket.")
    public Integer getNumVcpusPerSocket() {
        return this.numVcpusPerSocket;
    }

    public void setNumVcpusPerSocket(Integer numVcpusPerSocket) {
        this.numVcpusPerSocket = numVcpusPerSocket;
    }

    public VmDefStatusResources parentReference(Reference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to an entity that the VM cloned from. ")
    public Reference getParentReference() {
        return this.parentReference;
    }

    public void setParentReference(Reference parentReference) {
        this.parentReference = parentReference;
    }

    public VmDefStatusResources powerState(String powerState) {
        this.powerState = powerState;
        return this;
    }

    @ApiModelProperty(example="null", value="Current power state of the VM.")
    public String getPowerState() {
        return this.powerState;
    }

    public void setPowerState(String powerState) {
        this.powerState = powerState;
    }

    public VmDefStatusResources powerStateMechanism(VmPowerStateMechanism powerStateMechanism) {
        this.powerStateMechanism = powerStateMechanism;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmPowerStateMechanism getPowerStateMechanism() {
        return this.powerStateMechanism;
    }

    public void setPowerStateMechanism(VmPowerStateMechanism powerStateMechanism) {
        this.powerStateMechanism = powerStateMechanism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmDefStatusResources vmDefStatusResources = (VmDefStatusResources)o;
        return Objects.equals(this.bootConfig, vmDefStatusResources.bootConfig) && Objects.equals(this.diskList, vmDefStatusResources.diskList) && Objects.equals(this.gpuList, vmDefStatusResources.gpuList) && Objects.equals(this.guestCustomization, vmDefStatusResources.guestCustomization) && Objects.equals(this.hostReference, vmDefStatusResources.hostReference) && Objects.equals(this.hypervisorType, vmDefStatusResources.hypervisorType) && Objects.equals(this.memorySizeMib, vmDefStatusResources.memorySizeMib) && Objects.equals(this.nicList, vmDefStatusResources.nicList) && Objects.equals(this.numSockets, vmDefStatusResources.numSockets) && Objects.equals(this.numVcpusPerSocket, vmDefStatusResources.numVcpusPerSocket) && Objects.equals(this.parentReference, vmDefStatusResources.parentReference) && Objects.equals(this.powerState, vmDefStatusResources.powerState) && Objects.equals(this.powerStateMechanism, vmDefStatusResources.powerStateMechanism);
    }

    public int hashCode() {
        return Objects.hash(this.bootConfig, this.diskList, this.gpuList, this.guestCustomization, this.hostReference, this.hypervisorType, this.memorySizeMib, this.nicList, this.numSockets, this.numVcpusPerSocket, this.parentReference, this.powerState, this.powerStateMechanism);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmDefStatusResources {\n");
        sb.append("    bootConfig: ").append(this.toIndentedString(this.bootConfig)).append("\n");
        sb.append("    diskList: ").append(this.toIndentedString(this.diskList)).append("\n");
        sb.append("    gpuList: ").append(this.toIndentedString(this.gpuList)).append("\n");
        sb.append("    guestCustomization: ").append(this.toIndentedString(this.guestCustomization)).append("\n");
        sb.append("    hostReference: ").append(this.toIndentedString(this.hostReference)).append("\n");
        sb.append("    hypervisorType: ").append(this.toIndentedString(this.hypervisorType)).append("\n");
        sb.append("    memorySizeMib: ").append(this.toIndentedString(this.memorySizeMib)).append("\n");
        sb.append("    nicList: ").append(this.toIndentedString(this.nicList)).append("\n");
        sb.append("    numSockets: ").append(this.toIndentedString(this.numSockets)).append("\n");
        sb.append("    numVcpusPerSocket: ").append(this.toIndentedString(this.numVcpusPerSocket)).append("\n");
        sb.append("    parentReference: ").append(this.toIndentedString(this.parentReference)).append("\n");
        sb.append("    powerState: ").append(this.toIndentedString(this.powerState)).append("\n");
        sb.append("    powerStateMechanism: ").append(this.toIndentedString(this.powerStateMechanism)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

