/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ClusterReference;
import nutanix.model.MessageResource;
import nutanix.model.VmDefStatusResources;

@ApiModel(description="VM status definition.")
public class VmDefStatus {
    @SerializedName(value="cluster_reference")
    private ClusterReference clusterReference = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="message_list")
    private List<MessageResource> messageList = new ArrayList<MessageResource>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resources")
    private VmDefStatusResources resources = null;
    @SerializedName(value="state")
    private String state = null;

    public VmDefStatus clusterReference(ClusterReference clusterReference) {
        this.clusterReference = clusterReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to the cluster where this VM exists or needs to be migrated to ")
    public ClusterReference getClusterReference() {
        return this.clusterReference;
    }

    public void setClusterReference(ClusterReference clusterReference) {
        this.clusterReference = clusterReference;
    }

    public VmDefStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description or user annotation for the VM.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VmDefStatus messageList(List<MessageResource> messageList) {
        this.messageList = messageList;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error messages for the VM, if in an error state.")
    public List<MessageResource> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<MessageResource> messageList) {
        this.messageList = messageList;
    }

    public VmDefStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="VM Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VmDefStatus resources(VmDefStatusResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmDefStatusResources getResources() {
        return this.resources;
    }

    public void setResources(VmDefStatusResources resources) {
        this.resources = resources;
    }

    public VmDefStatus state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the vm entity.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmDefStatus vmDefStatus = (VmDefStatus)o;
        return Objects.equals(this.clusterReference, vmDefStatus.clusterReference) && Objects.equals(this.description, vmDefStatus.description) && Objects.equals(this.messageList, vmDefStatus.messageList) && Objects.equals(this.name, vmDefStatus.name) && Objects.equals(this.resources, vmDefStatus.resources) && Objects.equals(this.state, vmDefStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.clusterReference, this.description, this.messageList, this.name, this.resources, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmDefStatus {\n");
        sb.append("    clusterReference: ").append(this.toIndentedString(this.clusterReference)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    messageList: ").append(this.toIndentedString(this.messageList)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

