/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.DiskAddress;

@ApiModel(description="Indicates from which device a VM should boot.. One of disk_address or mac_address should be provided. ")
public class VmBootDevice {
    @SerializedName(value="disk_address")
    private DiskAddress diskAddress = null;
    @SerializedName(value="mac_address")
    private String macAddress = null;

    public VmBootDevice diskAddress(DiskAddress diskAddress) {
        this.diskAddress = diskAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address of disk to boot from.")
    public DiskAddress getDiskAddress() {
        return this.diskAddress;
    }

    public void setDiskAddress(DiskAddress diskAddress) {
        this.diskAddress = diskAddress;
    }

    public VmBootDevice macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="MAC address of nic to boot from.")
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmBootDevice vmBootDevice = (VmBootDevice)o;
        return Objects.equals(this.diskAddress, vmBootDevice.diskAddress) && Objects.equals(this.macAddress, vmBootDevice.macAddress);
    }

    public int hashCode() {
        return Objects.hash(this.diskAddress, this.macAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmBootDevice {\n");
        sb.append("    diskAddress: ").append(this.toIndentedString(this.diskAddress)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

