/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.ClusterReference;
import nutanix.model.VmResources;

@ApiModel(description="VM Input Definition.")
public class Vm {
    @SerializedName(value="cluster_reference")
    private ClusterReference clusterReference = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resources")
    private VmResources resources = null;

    public Vm clusterReference(ClusterReference clusterReference) {
        this.clusterReference = clusterReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to the cluster where this VM exists or needs to be migrated to. This is to support migration of a VM from one cluster to another cluster. ")
    public ClusterReference getClusterReference() {
        return this.clusterReference;
    }

    public void setClusterReference(ClusterReference clusterReference) {
        this.clusterReference = clusterReference;
    }

    public Vm description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description or user annotation for the VM.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Vm name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="VM Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vm resources(VmResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmResources getResources() {
        return this.resources;
    }

    public void setResources(VmResources resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vm vm = (Vm)o;
        return Objects.equals(this.clusterReference, vm.clusterReference) && Objects.equals(this.description, vm.description) && Objects.equals(this.name, vm.name) && Objects.equals(this.resources, vm.resources);
    }

    public int hashCode() {
        return Objects.hash(this.clusterReference, this.description, this.name, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vm {\n");
        sb.append("    clusterReference: ").append(this.toIndentedString(this.clusterReference)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

