/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.DirectoryServiceReference;
import nutanix.model.ProjectReference;
import nutanix.model.RoleReference;
import nutanix.model.UserDefStatusResourcesUsageSummary;

public class UserDefStatusResources {
    @SerializedName(value="directory_service_reference")
    private DirectoryServiceReference directoryServiceReference = null;
    @SerializedName(value="display_name")
    private String displayName = null;
    @SerializedName(value="projects_reference_list")
    private List<ProjectReference> projectsReferenceList = new ArrayList<ProjectReference>();
    @SerializedName(value="role_reference_list")
    private List<RoleReference> roleReferenceList = new ArrayList<RoleReference>();
    @SerializedName(value="usage_summary")
    private UserDefStatusResourcesUsageSummary usageSummary = null;
    @SerializedName(value="user_principal_name")
    private String userPrincipalName = null;
    @SerializedName(value="user_type")
    private String userType = null;

    public UserDefStatusResources directoryServiceReference(DirectoryServiceReference directoryServiceReference) {
        this.directoryServiceReference = directoryServiceReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Directory service reference if the user type is directory service. ")
    public DirectoryServiceReference getDirectoryServiceReference() {
        return this.directoryServiceReference;
    }

    public void setDirectoryServiceReference(DirectoryServiceReference directoryServiceReference) {
        this.directoryServiceReference = directoryServiceReference;
    }

    public UserDefStatusResources displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="User's display name(common name) from the directory service. ")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserDefStatusResources projectsReferenceList(List<ProjectReference> projectsReferenceList) {
        this.projectsReferenceList = projectsReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of project references.")
    public List<ProjectReference> getProjectsReferenceList() {
        return this.projectsReferenceList;
    }

    public void setProjectsReferenceList(List<ProjectReference> projectsReferenceList) {
        this.projectsReferenceList = projectsReferenceList;
    }

    public UserDefStatusResources roleReferenceList(List<RoleReference> roleReferenceList) {
        this.roleReferenceList = roleReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of role references.")
    public List<RoleReference> getRoleReferenceList() {
        return this.roleReferenceList;
    }

    public void setRoleReferenceList(List<RoleReference> roleReferenceList) {
        this.roleReferenceList = roleReferenceList;
    }

    public UserDefStatusResources usageSummary(UserDefStatusResourcesUsageSummary usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public UserDefStatusResourcesUsageSummary getUsageSummary() {
        return this.usageSummary;
    }

    public void setUsageSummary(UserDefStatusResourcesUsageSummary usageSummary) {
        this.usageSummary = usageSummary;
    }

    public UserDefStatusResources userPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    @ApiModelProperty(example="null", value="UserPrincipalName of the user in the directory service.")
    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public void setUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
    }

    public UserDefStatusResources userType(String userType) {
        this.userType = userType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefStatusResources userDefStatusResources = (UserDefStatusResources)o;
        return Objects.equals(this.directoryServiceReference, userDefStatusResources.directoryServiceReference) && Objects.equals(this.displayName, userDefStatusResources.displayName) && Objects.equals(this.projectsReferenceList, userDefStatusResources.projectsReferenceList) && Objects.equals(this.roleReferenceList, userDefStatusResources.roleReferenceList) && Objects.equals(this.usageSummary, userDefStatusResources.usageSummary) && Objects.equals(this.userPrincipalName, userDefStatusResources.userPrincipalName) && Objects.equals(this.userType, userDefStatusResources.userType);
    }

    public int hashCode() {
        return Objects.hash(this.directoryServiceReference, this.displayName, this.projectsReferenceList, this.roleReferenceList, this.usageSummary, this.userPrincipalName, this.userType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDefStatusResources {\n");
        sb.append("    directoryServiceReference: ").append(this.toIndentedString(this.directoryServiceReference)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    projectsReferenceList: ").append(this.toIndentedString(this.projectsReferenceList)).append("\n");
        sb.append("    roleReferenceList: ").append(this.toIndentedString(this.roleReferenceList)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    userPrincipalName: ").append(this.toIndentedString(this.userPrincipalName)).append("\n");
        sb.append("    userType: ").append(this.toIndentedString(this.userType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

