/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.MessageResource;
import nutanix.model.SubnetResourcesDefStatus;

@ApiModel(description="An intentful representation of a subnet status")
public class SubnetDefStatus {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="message_list")
    private List<MessageResource> messageList = new ArrayList<MessageResource>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resources")
    private SubnetResourcesDefStatus resources = null;
    @SerializedName(value="state")
    private String state = null;

    public SubnetDefStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description for subnet.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubnetDefStatus messageList(List<MessageResource> messageList) {
        this.messageList = messageList;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error messages for the {kind}}, if in an error state.")
    public List<MessageResource> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<MessageResource> messageList) {
        this.messageList = messageList;
    }

    public SubnetDefStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="subnet Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubnetDefStatus resources(SubnetResourcesDefStatus resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public SubnetResourcesDefStatus getResources() {
        return this.resources;
    }

    public void setResources(SubnetResourcesDefStatus resources) {
        this.resources = resources;
    }

    public SubnetDefStatus state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the subnet.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubnetDefStatus subnetDefStatus = (SubnetDefStatus)o;
        return Objects.equals(this.description, subnetDefStatus.description) && Objects.equals(this.messageList, subnetDefStatus.messageList) && Objects.equals(this.name, subnetDefStatus.name) && Objects.equals(this.resources, subnetDefStatus.resources) && Objects.equals(this.state, subnetDefStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.messageList, this.name, this.resources, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubnetDefStatus {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    messageList: ").append(this.toIndentedString(this.messageList)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

