/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The status of a REST API call. Only used when there is a failure to report. ")
public class Statuses {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="code")
    private Integer code = null;
    @SerializedName(value="details")
    private Map<String, String> details = new HashMap<String, String>();
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="status")
    private String status = null;

    @ApiModelProperty(example="null", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @ApiModelProperty(example="null", value="The HTTP error code")
    public Integer getCode() {
        return this.code;
    }

    public Statuses details(Map<String, String> details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom key-value details relevant to the status")
    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @ApiModelProperty(example="null", value="The entity kind (for example \"status\")")
    public String getKind() {
        return this.kind;
    }

    @ApiModelProperty(example="null", value="The reason for the status")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(example="null", value="One snake case word.")
    public String getReason() {
        return this.reason;
    }

    @ApiModelProperty(example="null", value="The only value possible is \"failure\"")
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statuses statuses = (Statuses)o;
        return Objects.equals(this.apiVersion, statuses.apiVersion) && Objects.equals(this.code, statuses.code) && Objects.equals(this.details, statuses.details) && Objects.equals(this.kind, statuses.kind) && Objects.equals(this.message, statuses.message) && Objects.equals(this.reason, statuses.reason) && Objects.equals(this.status, statuses.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.code, this.details, this.kind, this.message, this.reason, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Statuses {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

