/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.CertificationSigningInfo;
import org.joda.time.DateTime;

@ApiModel(description="SSL certificate.")
public class SslKey {
    @SerializedName(value="expire_datetime")
    private DateTime expireDatetime = null;
    @SerializedName(value="key_name")
    private String keyName = null;
    @SerializedName(value="key_type")
    private String keyType = null;
    @SerializedName(value="signing_info")
    private CertificationSigningInfo signingInfo = null;

    public SslKey expireDatetime(DateTime expireDatetime) {
        this.expireDatetime = expireDatetime;
        return this;
    }

    @ApiModelProperty(example="null", value="UTC date and time in RFC-3339 format when the key expires")
    public DateTime getExpireDatetime() {
        return this.expireDatetime;
    }

    public void setExpireDatetime(DateTime expireDatetime) {
        this.expireDatetime = expireDatetime;
    }

    public SslKey keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public SslKey keyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="SSL key type. Key types with RSA_2048, ECDSA_256 and ECDSA_384 are supported for key generation and importing. ")
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public SslKey signingInfo(CertificationSigningInfo signingInfo) {
        this.signingInfo = signingInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CertificationSigningInfo getSigningInfo() {
        return this.signingInfo;
    }

    public void setSigningInfo(CertificationSigningInfo signingInfo) {
        this.signingInfo = signingInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslKey sslKey = (SslKey)o;
        return Objects.equals(this.expireDatetime, sslKey.expireDatetime) && Objects.equals(this.keyName, sslKey.keyName) && Objects.equals(this.keyType, sslKey.keyType) && Objects.equals(this.signingInfo, sslKey.signingInfo);
    }

    public int hashCode() {
        return Objects.hash(this.expireDatetime, this.keyName, this.keyType, this.signingInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SslKey {\n");
        sb.append("    expireDatetime: ").append(this.toIndentedString(this.expireDatetime)).append("\n");
        sb.append("    keyName: ").append(this.toIndentedString(this.keyName)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString(this.keyType)).append("\n");
        sb.append("    signingInfo: ").append(this.toIndentedString(this.signingInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

