/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Resource utilization and limits for a domain")
public class ResourceUtilizationStatus {
    @SerializedName(value="limit")
    private Integer limit = null;
    @SerializedName(value="resource_type")
    private String resourceType = null;
    @SerializedName(value="units")
    private String units = null;
    @SerializedName(value="value")
    private Integer value = null;

    public ResourceUtilizationStatus limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource consumption limit (unspecified is unlimited)")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ResourceUtilizationStatus resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of resource (for example storage, CPUs)")
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceUtilizationStatus units(String units) {
        this.units = units;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The units of the resource type")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public ResourceUtilizationStatus value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The amount of resource consumed")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUtilizationStatus resourceUtilizationStatus = (ResourceUtilizationStatus)o;
        return Objects.equals(this.limit, resourceUtilizationStatus.limit) && Objects.equals(this.resourceType, resourceUtilizationStatus.resourceType) && Objects.equals(this.units, resourceUtilizationStatus.units) && Objects.equals(this.value, resourceUtilizationStatus.value);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.resourceType, this.units, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceUtilizationStatus {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

