/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Specify the limits and units for a resource type")
public class ResourceUtilizationSpec {
    @SerializedName(value="limit")
    private Integer limit = null;
    @SerializedName(value="resource_type")
    private String resourceType = null;

    public ResourceUtilizationSpec limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource consumption limit")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ResourceUtilizationSpec resourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of resource (for example storage, CPUs)")
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUtilizationSpec resourceUtilizationSpec = (ResourceUtilizationSpec)o;
        return Objects.equals(this.limit, resourceUtilizationSpec.limit) && Objects.equals(this.resourceType, resourceUtilizationSpec.resourceType);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.resourceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceUtilizationSpec {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

