/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ResourceDomainSpec;
import nutanix.model.RoleReference;
import nutanix.model.SubnetReference;
import nutanix.model.UserReferenceWithName;

public class ProjectResources {
    @SerializedName(value="default_subnet_reference")
    private SubnetReference defaultSubnetReference = null;
    @SerializedName(value="external_user_group_list")
    private List<String> externalUserGroupList = new ArrayList<String>();
    @SerializedName(value="resource_domain")
    private ResourceDomainSpec resourceDomain = null;
    @SerializedName(value="role_reference")
    private RoleReference roleReference = null;
    @SerializedName(value="subnet_reference_list")
    private List<SubnetReference> subnetReferenceList = new ArrayList<SubnetReference>();
    @SerializedName(value="user_reference_list")
    private List<UserReferenceWithName> userReferenceList = new ArrayList<UserReferenceWithName>();

    public ProjectResources defaultSubnetReference(SubnetReference defaultSubnetReference) {
        this.defaultSubnetReference = defaultSubnetReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional default subnet if one is specified")
    public SubnetReference getDefaultSubnetReference() {
        return this.defaultSubnetReference;
    }

    public void setDefaultSubnetReference(SubnetReference defaultSubnetReference) {
        this.defaultSubnetReference = defaultSubnetReference;
    }

    public ProjectResources externalUserGroupList(List<String> externalUserGroupList) {
        this.externalUserGroupList = externalUserGroupList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of directory service group's distinguished name. Those groups are not managed by Nutanix. ")
    public List<String> getExternalUserGroupList() {
        return this.externalUserGroupList;
    }

    public void setExternalUserGroupList(List<String> externalUserGroupList) {
        this.externalUserGroupList = externalUserGroupList;
    }

    public ProjectResources resourceDomain(ResourceDomainSpec resourceDomain) {
        this.resourceDomain = resourceDomain;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ResourceDomainSpec getResourceDomain() {
        return this.resourceDomain;
    }

    public void setResourceDomain(ResourceDomainSpec resourceDomain) {
        this.resourceDomain = resourceDomain;
    }

    public ProjectResources roleReference(RoleReference roleReference) {
        this.roleReference = roleReference;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The role assigned to project users")
    public RoleReference getRoleReference() {
        return this.roleReference;
    }

    public void setRoleReference(RoleReference roleReference) {
        this.roleReference = roleReference;
    }

    public ProjectResources subnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of subnets for the project.")
    public List<SubnetReference> getSubnetReferenceList() {
        return this.subnetReferenceList;
    }

    public void setSubnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
    }

    public ProjectResources userReferenceList(List<UserReferenceWithName> userReferenceList) {
        this.userReferenceList = userReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of users in the project.")
    public List<UserReferenceWithName> getUserReferenceList() {
        return this.userReferenceList;
    }

    public void setUserReferenceList(List<UserReferenceWithName> userReferenceList) {
        this.userReferenceList = userReferenceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectResources projectResources = (ProjectResources)o;
        return Objects.equals(this.defaultSubnetReference, projectResources.defaultSubnetReference) && Objects.equals(this.externalUserGroupList, projectResources.externalUserGroupList) && Objects.equals(this.resourceDomain, projectResources.resourceDomain) && Objects.equals(this.roleReference, projectResources.roleReference) && Objects.equals(this.subnetReferenceList, projectResources.subnetReferenceList) && Objects.equals(this.userReferenceList, projectResources.userReferenceList);
    }

    public int hashCode() {
        return Objects.hash(this.defaultSubnetReference, this.externalUserGroupList, this.resourceDomain, this.roleReference, this.subnetReferenceList, this.userReferenceList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectResources {\n");
        sb.append("    defaultSubnetReference: ").append(this.toIndentedString(this.defaultSubnetReference)).append("\n");
        sb.append("    externalUserGroupList: ").append(this.toIndentedString(this.externalUserGroupList)).append("\n");
        sb.append("    resourceDomain: ").append(this.toIndentedString(this.resourceDomain)).append("\n");
        sb.append("    roleReference: ").append(this.toIndentedString(this.roleReference)).append("\n");
        sb.append("    subnetReferenceList: ").append(this.toIndentedString(this.subnetReferenceList)).append("\n");
        sb.append("    userReferenceList: ").append(this.toIndentedString(this.userReferenceList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

