/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.UpgradeNotification;
import org.joda.time.DateTime;

@ApiModel(description="Software information from Nutanix Portal")
public class PortalSoftware {
    @SerializedName(value="compatible_pe_version_list")
    private List<String> compatiblePeVersionList = new ArrayList<String>();
    @SerializedName(value="compatible_version_list")
    private List<String> compatibleVersionList = new ArrayList<String>();
    @SerializedName(value="md5sum")
    private String md5sum = null;
    @SerializedName(value="release_date")
    private DateTime releaseDate = null;
    @SerializedName(value="release_note_url")
    private String releaseNoteUrl = null;
    @SerializedName(value="size_bytes")
    private Long sizeBytes = null;
    @SerializedName(value="software_type")
    private String softwareType = null;
    @SerializedName(value="upgrade_notification")
    private UpgradeNotification upgradeNotification = null;
    @SerializedName(value="version")
    private String version = null;

    public PortalSoftware compatiblePeVersionList(List<String> compatiblePeVersionList) {
        this.compatiblePeVersionList = compatiblePeVersionList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of Prism Element compatible versions")
    public List<String> getCompatiblePeVersionList() {
        return this.compatiblePeVersionList;
    }

    public void setCompatiblePeVersionList(List<String> compatiblePeVersionList) {
        this.compatiblePeVersionList = compatiblePeVersionList;
    }

    public PortalSoftware compatibleVersionList(List<String> compatibleVersionList) {
        this.compatibleVersionList = compatibleVersionList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of software versions that this version can be upgraded from ")
    public List<String> getCompatibleVersionList() {
        return this.compatibleVersionList;
    }

    public void setCompatibleVersionList(List<String> compatibleVersionList) {
        this.compatibleVersionList = compatibleVersionList;
    }

    public PortalSoftware md5sum(String md5sum) {
        this.md5sum = md5sum;
        return this;
    }

    @ApiModelProperty(example="null", value="MD5 checksum of the software file")
    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public PortalSoftware releaseDate(DateTime releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Release date of this software in RFC3339 format. ")
    public DateTime getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(DateTime releaseDate) {
        this.releaseDate = releaseDate;
    }

    public PortalSoftware releaseNoteUrl(String releaseNoteUrl) {
        this.releaseNoteUrl = releaseNoteUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL to point to the support portal release note of this software. Currently only set and used for NOS releases ")
    public String getReleaseNoteUrl() {
        return this.releaseNoteUrl;
    }

    public void setReleaseNoteUrl(String releaseNoteUrl) {
        this.releaseNoteUrl = releaseNoteUrl;
    }

    public PortalSoftware sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Total size of the software file in bytes")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public PortalSoftware softwareType(String softwareType) {
        this.softwareType = softwareType;
        return this;
    }

    @ApiModelProperty(example="null", value="Software type")
    public String getSoftwareType() {
        return this.softwareType;
    }

    public void setSoftwareType(String softwareType) {
        this.softwareType = softwareType;
    }

    public PortalSoftware upgradeNotification(UpgradeNotification upgradeNotification) {
        this.upgradeNotification = upgradeNotification;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public UpgradeNotification getUpgradeNotification() {
        return this.upgradeNotification;
    }

    public void setUpgradeNotification(UpgradeNotification upgradeNotification) {
        this.upgradeNotification = upgradeNotification;
    }

    public PortalSoftware version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Software version string")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalSoftware portalSoftware = (PortalSoftware)o;
        return Objects.equals(this.compatiblePeVersionList, portalSoftware.compatiblePeVersionList) && Objects.equals(this.compatibleVersionList, portalSoftware.compatibleVersionList) && Objects.equals(this.md5sum, portalSoftware.md5sum) && Objects.equals(this.releaseDate, portalSoftware.releaseDate) && Objects.equals(this.releaseNoteUrl, portalSoftware.releaseNoteUrl) && Objects.equals(this.sizeBytes, portalSoftware.sizeBytes) && Objects.equals(this.softwareType, portalSoftware.softwareType) && Objects.equals(this.upgradeNotification, portalSoftware.upgradeNotification) && Objects.equals(this.version, portalSoftware.version);
    }

    public int hashCode() {
        return Objects.hash(this.compatiblePeVersionList, this.compatibleVersionList, this.md5sum, this.releaseDate, this.releaseNoteUrl, this.sizeBytes, this.softwareType, this.upgradeNotification, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PortalSoftware {\n");
        sb.append("    compatiblePeVersionList: ").append(this.toIndentedString(this.compatiblePeVersionList)).append("\n");
        sb.append("    compatibleVersionList: ").append(this.toIndentedString(this.compatibleVersionList)).append("\n");
        sb.append("    md5sum: ").append(this.toIndentedString(this.md5sum)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    releaseNoteUrl: ").append(this.toIndentedString(this.releaseNoteUrl)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    softwareType: ").append(this.toIndentedString(this.softwareType)).append("\n");
        sb.append("    upgradeNotification: ").append(this.toIndentedString(this.upgradeNotification)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

