/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.PcVmNicConfiguration;

@ApiModel(description="Prism central VM configuration.")
public class PcVm {
    @SerializedName(value="container_name")
    private String containerName = null;
    @SerializedName(value="data_disk_size_bytes")
    private Long dataDiskSizeBytes = null;
    @SerializedName(value="dns_ip_list")
    private List<String> dnsIpList = new ArrayList<String>();
    @SerializedName(value="memory_size_bytes")
    private Long memorySizeBytes = null;
    @SerializedName(value="nic_list")
    private List<PcVmNicConfiguration> nicList = new ArrayList<PcVmNicConfiguration>();
    @SerializedName(value="num_sockets")
    private Long numSockets = null;
    @SerializedName(value="vm_name")
    private String vmName = null;
    @SerializedName(value="vm_size")
    private String vmSize = "SMALL";

    public PcVm containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @ApiModelProperty(example="null", value="Container name.")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public PcVm dataDiskSizeBytes(Long dataDiskSizeBytes) {
        this.dataDiskSizeBytes = dataDiskSizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Data disk size in bytes.")
    public Long getDataDiskSizeBytes() {
        return this.dataDiskSizeBytes;
    }

    public void setDataDiskSizeBytes(Long dataDiskSizeBytes) {
        this.dataDiskSizeBytes = dataDiskSizeBytes;
    }

    public PcVm dnsIpList(List<String> dnsIpList) {
        this.dnsIpList = dnsIpList;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of DNS IP addresses.")
    public List<String> getDnsIpList() {
        return this.dnsIpList;
    }

    public void setDnsIpList(List<String> dnsIpList) {
        this.dnsIpList = dnsIpList;
    }

    public PcVm memorySizeBytes(Long memorySizeBytes) {
        this.memorySizeBytes = memorySizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Memory in bytes.")
    public Long getMemorySizeBytes() {
        return this.memorySizeBytes;
    }

    public void setMemorySizeBytes(Long memorySizeBytes) {
        this.memorySizeBytes = memorySizeBytes;
    }

    public PcVm nicList(List<PcVmNicConfiguration> nicList) {
        this.nicList = nicList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<PcVmNicConfiguration> getNicList() {
        return this.nicList;
    }

    public void setNicList(List<PcVmNicConfiguration> nicList) {
        this.nicList = nicList;
    }

    public PcVm numSockets(Long numSockets) {
        this.numSockets = numSockets;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of sockets allocated per VM.")
    public Long getNumSockets() {
        return this.numSockets;
    }

    public void setNumSockets(Long numSockets) {
        this.numSockets = numSockets;
    }

    public PcVm vmName(String vmName) {
        this.vmName = vmName;
        return this;
    }

    @ApiModelProperty(example="null", value="VM name.")
    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public PcVm vmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getVmSize() {
        return this.vmSize;
    }

    public void setVmSize(String vmSize) {
        this.vmSize = vmSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PcVm pcVm = (PcVm)o;
        return Objects.equals(this.containerName, pcVm.containerName) && Objects.equals(this.dataDiskSizeBytes, pcVm.dataDiskSizeBytes) && Objects.equals(this.dnsIpList, pcVm.dnsIpList) && Objects.equals(this.memorySizeBytes, pcVm.memorySizeBytes) && Objects.equals(this.nicList, pcVm.nicList) && Objects.equals(this.numSockets, pcVm.numSockets) && Objects.equals(this.vmName, pcVm.vmName) && Objects.equals(this.vmSize, pcVm.vmSize);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.dataDiskSizeBytes, this.dnsIpList, this.memorySizeBytes, this.nicList, this.numSockets, this.vmName, this.vmSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PcVm {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    dataDiskSizeBytes: ").append(this.toIndentedString(this.dataDiskSizeBytes)).append("\n");
        sb.append("    dnsIpList: ").append(this.toIndentedString(this.dnsIpList)).append("\n");
        sb.append("    memorySizeBytes: ").append(this.toIndentedString(this.memorySizeBytes)).append("\n");
        sb.append("    nicList: ").append(this.toIndentedString(this.nicList)).append("\n");
        sb.append("    numSockets: ").append(this.toIndentedString(this.numSockets)).append("\n");
        sb.append("    vmName: ").append(this.toIndentedString(this.vmName)).append("\n");
        sb.append("    vmSize: ").append(this.toIndentedString(this.vmSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

