/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Network Configuration for PC VM.")
public class NetworkConfig {
    @SerializedName(value="default_gateway")
    private String defaultGateway = null;
    @SerializedName(value="network_name")
    private String networkName = null;
    @SerializedName(value="network_uuid")
    private String networkUuid = null;
    @SerializedName(value="subnet_mask")
    private String subnetMask = null;

    public NetworkConfig defaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
        return this;
    }

    @ApiModelProperty(example="null", value="Gateway IP address.")
    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public NetworkConfig networkName(String networkName) {
        this.networkName = networkName;
        return this;
    }

    @ApiModelProperty(example="null", value="Network name. For AHV this field should be network name and for ESX this field should be port group. ")
    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public NetworkConfig networkUuid(String networkUuid) {
        this.networkUuid = networkUuid;
        return this;
    }

    @ApiModelProperty(example="null", value="Network UUID.")
    public String getNetworkUuid() {
        return this.networkUuid;
    }

    public void setNetworkUuid(String networkUuid) {
        this.networkUuid = networkUuid;
    }

    public NetworkConfig subnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @ApiModelProperty(example="null", value="Subnet mask IP address.")
    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkConfig networkConfig = (NetworkConfig)o;
        return Objects.equals(this.defaultGateway, networkConfig.defaultGateway) && Objects.equals(this.networkName, networkConfig.networkName) && Objects.equals(this.networkUuid, networkConfig.networkUuid) && Objects.equals(this.subnetMask, networkConfig.subnetMask);
    }

    public int hashCode() {
        return Objects.hash(this.defaultGateway, this.networkName, this.networkUuid, this.subnetMask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkConfig {\n");
        sb.append("    defaultGateway: ").append(this.toIndentedString(this.defaultGateway)).append("\n");
        sb.append("    networkName: ").append(this.toIndentedString(this.networkName)).append("\n");
        sb.append("    networkUuid: ").append(this.toIndentedString(this.networkUuid)).append("\n");
        sb.append("    subnetMask: ").append(this.toIndentedString(this.subnetMask)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

