/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.Address;
import nutanix.model.DhcpOptions;
import nutanix.model.IpPool;

@ApiModel(description="IP config.")
public class IpConfig {
    @SerializedName(value="default_gateway_ip")
    private String defaultGatewayIp = null;
    @SerializedName(value="dhcp_options")
    private DhcpOptions dhcpOptions = null;
    @SerializedName(value="dhcp_server_address")
    private Address dhcpServerAddress = null;
    @SerializedName(value="pool_list")
    private List<IpPool> poolList = new ArrayList<IpPool>();
    @SerializedName(value="prefix_length")
    private Integer prefixLength = null;
    @SerializedName(value="subnet_ip")
    private String subnetIp = null;

    public IpConfig defaultGatewayIp(String defaultGatewayIp) {
        this.defaultGatewayIp = defaultGatewayIp;
        return this;
    }

    @ApiModelProperty(example="null", value="Default gateway IP address.")
    public String getDefaultGatewayIp() {
        return this.defaultGatewayIp;
    }

    public void setDefaultGatewayIp(String defaultGatewayIp) {
        this.defaultGatewayIp = defaultGatewayIp;
    }

    public IpConfig dhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DhcpOptions getDhcpOptions() {
        return this.dhcpOptions;
    }

    public void setDhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    public IpConfig dhcpServerAddress(Address dhcpServerAddress) {
        this.dhcpServerAddress = dhcpServerAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Address getDhcpServerAddress() {
        return this.dhcpServerAddress;
    }

    public void setDhcpServerAddress(Address dhcpServerAddress) {
        this.dhcpServerAddress = dhcpServerAddress;
    }

    public IpConfig poolList(List<IpPool> poolList) {
        this.poolList = poolList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<IpPool> getPoolList() {
        return this.poolList;
    }

    public void setPoolList(List<IpPool> poolList) {
        this.poolList = poolList;
    }

    public IpConfig prefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public IpConfig subnetIp(String subnetIp) {
        this.subnetIp = subnetIp;
        return this;
    }

    @ApiModelProperty(example="null", value="Subnet IP address.")
    public String getSubnetIp() {
        return this.subnetIp;
    }

    public void setSubnetIp(String subnetIp) {
        this.subnetIp = subnetIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpConfig ipConfig = (IpConfig)o;
        return Objects.equals(this.defaultGatewayIp, ipConfig.defaultGatewayIp) && Objects.equals(this.dhcpOptions, ipConfig.dhcpOptions) && Objects.equals(this.dhcpServerAddress, ipConfig.dhcpServerAddress) && Objects.equals(this.poolList, ipConfig.poolList) && Objects.equals(this.prefixLength, ipConfig.prefixLength) && Objects.equals(this.subnetIp, ipConfig.subnetIp);
    }

    public int hashCode() {
        return Objects.hash(this.defaultGatewayIp, this.dhcpOptions, this.dhcpServerAddress, this.poolList, this.prefixLength, this.subnetIp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IpConfig {\n");
        sb.append("    defaultGatewayIp: ").append(this.toIndentedString(this.defaultGatewayIp)).append("\n");
        sb.append("    dhcpOptions: ").append(this.toIndentedString(this.dhcpOptions)).append("\n");
        sb.append("    dhcpServerAddress: ").append(this.toIndentedString(this.dhcpServerAddress)).append("\n");
        sb.append("    poolList: ").append(this.toIndentedString(this.poolList)).append("\n");
        sb.append("    prefixLength: ").append(this.toIndentedString(this.prefixLength)).append("\n");
        sb.append("    subnetIp: ").append(this.toIndentedString(this.subnetIp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

