/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An IP address.")
public class IpAddress {
    @SerializedName(value="ip")
    private String ip = null;
    @SerializedName(value="type")
    private String type = null;

    public IpAddress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(example="null", value="Address string.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public IpAddress type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Address type. It can only be \"ASSIGNED\" in the spec. If no type is specified in the spec, the default type is set to \"ASSIGNED\". ")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAddress ipAddress = (IpAddress)o;
        return Objects.equals(this.ip, ipAddress.ip) && Objects.equals(this.type, ipAddress.type);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IpAddress {\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

