/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The image version, which is composed of a product name and product version.")
public class ImageVersion {
    @SerializedName(value="product_name")
    private String productName = null;
    @SerializedName(value="product_version")
    private String productVersion = null;

    public ImageVersion productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the producer/distribution of the image. For example windows or red hat.")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public ImageVersion productVersion(String productVersion) {
        this.productVersion = productVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version string for the disk image.")
    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageVersion imageVersion = (ImageVersion)o;
        return Objects.equals(this.productName, imageVersion.productName) && Objects.equals(this.productVersion, imageVersion.productVersion);
    }

    public int hashCode() {
        return Objects.hash(this.productName, this.productVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageVersion {\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    productVersion: ").append(this.toIndentedString(this.productVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

