/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Checksum;
import nutanix.model.ImageVersion;

@ApiModel(description="Describes the image spec resources object.")
public class ImageResources {
    @SerializedName(value="checksum")
    private Checksum checksum = null;
    @SerializedName(value="image_type")
    private String imageType = null;
    @SerializedName(value="source_uri")
    private String sourceUri = null;
    @SerializedName(value="version")
    private ImageVersion version = null;

    public ImageResources checksum(Checksum checksum) {
        this.checksum = checksum;
        return this;
    }

    @ApiModelProperty(example="null", value="Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.")
    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public ImageResources imageType(String imageType) {
        this.imageType = imageType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of image.")
    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public ImageResources sourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
        return this;
    }

    @ApiModelProperty(example="null", value="The source URI points at the location of a the source image which is used to create/update image.")
    public String getSourceUri() {
        return this.sourceUri;
    }

    public void setSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
    }

    public ImageResources version(ImageVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The image version")
    public ImageVersion getVersion() {
        return this.version;
    }

    public void setVersion(ImageVersion version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageResources imageResources = (ImageResources)o;
        return Objects.equals(this.checksum, imageResources.checksum) && Objects.equals(this.imageType, imageResources.imageType) && Objects.equals(this.sourceUri, imageResources.sourceUri) && Objects.equals(this.version, imageResources.version);
    }

    public int hashCode() {
        return Objects.hash(this.checksum, this.imageType, this.sourceUri, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageResources {\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    imageType: ").append(this.toIndentedString(this.imageType)).append("\n");
        sb.append("    sourceUri: ").append(this.toIndentedString(this.sourceUri)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

