/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Image;
import nutanix.model.ImageDefStatus;
import nutanix.model.ImageMetadata;

@ApiModel(description="Response object for intentful operations on a image")
public class ImageIntentResponse {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="metadata")
    private ImageMetadata metadata = null;
    @SerializedName(value="spec")
    private Image spec = null;
    @SerializedName(value="status")
    private ImageDefStatus status = null;

    public ImageIntentResponse apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ImageIntentResponse metadata(ImageMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public ImageMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ImageMetadata metadata) {
        this.metadata = metadata;
    }

    public ImageIntentResponse spec(Image spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Image getSpec() {
        return this.spec;
    }

    public void setSpec(Image spec) {
        this.spec = spec;
    }

    public ImageIntentResponse status(ImageDefStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ImageDefStatus getStatus() {
        return this.status;
    }

    public void setStatus(ImageDefStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageIntentResponse imageIntentResponse = (ImageIntentResponse)o;
        return Objects.equals(this.apiVersion, imageIntentResponse.apiVersion) && Objects.equals(this.metadata, imageIntentResponse.metadata) && Objects.equals(this.spec, imageIntentResponse.spec) && Objects.equals(this.status, imageIntentResponse.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageIntentResponse {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

