/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Host;
import nutanix.model.HostDefStatus;
import nutanix.model.HostMetadata;

@ApiModel(description="Response object for intentful operations on a host")
public class HostIntentResource {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="metadata")
    private HostMetadata metadata = null;
    @SerializedName(value="spec")
    private Host spec = null;
    @SerializedName(value="status")
    private HostDefStatus status = null;

    public HostIntentResource apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public HostIntentResource metadata(HostMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public HostMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(HostMetadata metadata) {
        this.metadata = metadata;
    }

    public HostIntentResource spec(Host spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Host getSpec() {
        return this.spec;
    }

    public void setSpec(Host spec) {
        this.spec = spec;
    }

    public HostIntentResource status(HostDefStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public HostDefStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostDefStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostIntentResource hostIntentResource = (HostIntentResource)o;
        return Objects.equals(this.apiVersion, hostIntentResource.apiVersion) && Objects.equals(this.metadata, hostIntentResource.metadata) && Objects.equals(this.spec, hostIntentResource.spec) && Objects.equals(this.status, hostIntentResource.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostIntentResource {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

