/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Host GPU.")
public class HostGpu {
    @SerializedName(value="device_id")
    private Integer deviceId = null;
    @SerializedName(value="mode")
    private String mode = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="numa_node")
    private Integer numaNode = null;
    @SerializedName(value="pci_address")
    private String pciAddress = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="vendor")
    private String vendor = null;

    public HostGpu deviceId(Integer deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    @ApiModelProperty(example="null", value="The device ID of the GPU.")
    public Integer getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public HostGpu mode(String mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this GPU.")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public HostGpu name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the host GPU.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HostGpu numaNode(Integer numaNode) {
        this.numaNode = numaNode;
        return this;
    }

    @ApiModelProperty(example="null", value="NUMA node this GPU belongs to.")
    public Integer getNumaNode() {
        return this.numaNode;
    }

    public void setNumaNode(Integer numaNode) {
        this.numaNode = numaNode;
    }

    public HostGpu pciAddress(String pciAddress) {
        this.pciAddress = pciAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="GPU {segment:bus:device:function} (sbdf) address.")
    public String getPciAddress() {
        return this.pciAddress;
    }

    public void setPciAddress(String pciAddress) {
        this.pciAddress = pciAddress;
    }

    public HostGpu status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Current status of the physical GPU.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public HostGpu vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @ApiModelProperty(example="null", value="The vendor of the GPU.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostGpu hostGpu = (HostGpu)o;
        return Objects.equals(this.deviceId, hostGpu.deviceId) && Objects.equals(this.mode, hostGpu.mode) && Objects.equals(this.name, hostGpu.name) && Objects.equals(this.numaNode, hostGpu.numaNode) && Objects.equals(this.pciAddress, hostGpu.pciAddress) && Objects.equals(this.status, hostGpu.status) && Objects.equals(this.vendor, hostGpu.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.mode, this.name, this.numaNode, this.pciAddress, this.status, this.vendor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostGpu {\n");
        sb.append("    deviceId: ").append(this.toIndentedString(this.deviceId)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numaNode: ").append(this.toIndentedString(this.numaNode)).append("\n");
        sb.append("    pciAddress: ").append(this.toIndentedString(this.pciAddress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

