/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="If this field is set, the guest will be customized using Sysprep. At the very least, unattend_xml should be provided. ")
public class GuestCustomizationSysprep {
    @SerializedName(value="install_type")
    private String installType = "PREPARED";
    @SerializedName(value="unattend_xml")
    private String unattendXml = null;

    public GuestCustomizationSysprep installType(String installType) {
        this.installType = installType;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the guest will be freshly installed using this unattend configuration, or whether this unattend configuration will be applied to a pre-prepared image. Default is \"PREPARED\". ")
    public String getInstallType() {
        return this.installType;
    }

    public void setInstallType(String installType) {
        this.installType = installType;
    }

    public GuestCustomizationSysprep unattendXml(String unattendXml) {
        this.unattendXml = unattendXml;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="This field contains a Sysprep unattend xml definition, as a string. The value must be base64 encoded. ")
    public String getUnattendXml() {
        return this.unattendXml;
    }

    public void setUnattendXml(String unattendXml) {
        this.unattendXml = unattendXml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestCustomizationSysprep guestCustomizationSysprep = (GuestCustomizationSysprep)o;
        return Objects.equals(this.installType, guestCustomizationSysprep.installType) && Objects.equals(this.unattendXml, guestCustomizationSysprep.unattendXml);
    }

    public int hashCode() {
        return Objects.hash(this.installType, this.unattendXml);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestCustomizationSysprep {\n");
        sb.append("    installType: ").append(this.toIndentedString(this.installType)).append("\n");
        sb.append("    unattendXml: ").append(this.toIndentedString(this.unattendXml)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

