/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.GuestCustomizationCloudInit;
import nutanix.model.GuestCustomizationSysprep;

@ApiModel(description="VM guests may be customized at boot time using one of several different methods. Currently, cloud-init w/ ConfigDriveV2 (for Linux VMs) and Sysprep (for Windows VMs) are supported. Only one of sysprep or cloud_init should be provided. Note that guest customization can currently only be set during VM creation. Attempting to change it after creation will result in an error. ")
public class GuestCustomization {
    @SerializedName(value="cloud_init")
    private GuestCustomizationCloudInit cloudInit = null;
    @SerializedName(value="sysprep")
    private GuestCustomizationSysprep sysprep = null;

    public GuestCustomization cloudInit(GuestCustomizationCloudInit cloudInit) {
        this.cloudInit = cloudInit;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GuestCustomizationCloudInit getCloudInit() {
        return this.cloudInit;
    }

    public void setCloudInit(GuestCustomizationCloudInit cloudInit) {
        this.cloudInit = cloudInit;
    }

    public GuestCustomization sysprep(GuestCustomizationSysprep sysprep) {
        this.sysprep = sysprep;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GuestCustomizationSysprep getSysprep() {
        return this.sysprep;
    }

    public void setSysprep(GuestCustomizationSysprep sysprep) {
        this.sysprep = sysprep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestCustomization guestCustomization = (GuestCustomization)o;
        return Objects.equals(this.cloudInit, guestCustomization.cloudInit) && Objects.equals(this.sysprep, guestCustomization.sysprep);
    }

    public int hashCode() {
        return Objects.hash(this.cloudInit, this.sysprep);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestCustomization {\n");
        sb.append("    cloudInit: ").append(this.toIndentedString(this.cloudInit)).append("\n");
        sb.append("    sysprep: ").append(this.toIndentedString(this.sysprep)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

