/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.GroupsAttributeType;
import nutanix.model.GroupsRequestedAttribute;
import nutanix.model.GroupsSortDownsamplingFunction;
import nutanix.model.GroupsSortOrder;

@ApiModel(description="Get Entities Request.")
public class GroupsGetEntitiesRequest {
    @SerializedName(value="bucket_boundary")
    private Integer bucketBoundary = null;
    @SerializedName(value="downsampling_interval")
    private Integer downsamplingInterval = null;
    @SerializedName(value="entity_ids")
    private List<String> entityIds = new ArrayList<String>();
    @SerializedName(value="entity_type")
    private String entityType = null;
    @SerializedName(value="filter_criteria")
    private String filterCriteria = null;
    @SerializedName(value="group_attributes")
    private List<GroupsRequestedAttribute> groupAttributes = new ArrayList<GroupsRequestedAttribute>();
    @SerializedName(value="group_count")
    private Long groupCount = null;
    @SerializedName(value="group_member_attributes")
    private List<GroupsRequestedAttribute> groupMemberAttributes = new ArrayList<GroupsRequestedAttribute>();
    @SerializedName(value="group_member_count")
    private Long groupMemberCount = null;
    @SerializedName(value="group_member_offset")
    private Long groupMemberOffset = null;
    @SerializedName(value="group_member_sort_attribute")
    private String groupMemberSortAttribute = null;
    @SerializedName(value="group_member_sort_downsampling_function")
    private GroupsSortDownsamplingFunction groupMemberSortDownsamplingFunction = null;
    @SerializedName(value="group_member_sort_order")
    private GroupsSortOrder groupMemberSortOrder = null;
    @SerializedName(value="group_offset")
    private Long groupOffset = null;
    @SerializedName(value="group_sort_attribute")
    private String groupSortAttribute = null;
    @SerializedName(value="group_sort_downsample_function")
    private GroupsSortDownsamplingFunction groupSortDownsampleFunction = null;
    @SerializedName(value="group_sort_order")
    private GroupsSortOrder groupSortOrder = null;
    @SerializedName(value="grouping_attribute")
    private String groupingAttribute = null;
    @SerializedName(value="grouping_attribute_type")
    private GroupsAttributeType groupingAttributeType = null;
    @SerializedName(value="interval_end_ms")
    private Long intervalEndMs = 0L;
    @SerializedName(value="interval_start_ms")
    private Long intervalStartMs = 0L;
    @SerializedName(value="number_of_buckets")
    private Integer numberOfBuckets = null;
    @SerializedName(value="number_of_intervals_for_latest_data")
    private Integer numberOfIntervalsForLatestData = null;
    @SerializedName(value="query_name")
    private String queryName = null;

    public GroupsGetEntitiesRequest bucketBoundary(Integer bucketBoundary) {
        this.bucketBoundary = bucketBoundary;
        return this;
    }

    @ApiModelProperty(example="null", value="For grouping, the boundary to snap to when grouping.")
    public Integer getBucketBoundary() {
        return this.bucketBoundary;
    }

    public void setBucketBoundary(Integer bucketBoundary) {
        this.bucketBoundary = bucketBoundary;
    }

    public GroupsGetEntitiesRequest downsamplingInterval(Integer downsamplingInterval) {
        this.downsamplingInterval = downsamplingInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="Downsampling interval to apply to query if override is desired. ")
    public Integer getDownsamplingInterval() {
        return this.downsamplingInterval;
    }

    public void setDownsamplingInterval(Integer downsamplingInterval) {
        this.downsamplingInterval = downsamplingInterval;
    }

    public GroupsGetEntitiesRequest entityIds(List<String> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of entities that the request will be scoped to.")
    public List<String> getEntityIds() {
        return this.entityIds;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public GroupsGetEntitiesRequest entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity type that will be requested.")
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public GroupsGetEntitiesRequest filterCriteria(String filterCriteria) {
        this.filterCriteria = filterCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="FIQL filter criteria that will be used to filter the returned data. ")
    public String getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(String filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public GroupsGetEntitiesRequest groupAttributes(List<GroupsRequestedAttribute> groupAttributes) {
        this.groupAttributes = groupAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<GroupsRequestedAttribute> getGroupAttributes() {
        return this.groupAttributes;
    }

    public void setGroupAttributes(List<GroupsRequestedAttribute> groupAttributes) {
        this.groupAttributes = groupAttributes;
    }

    public GroupsGetEntitiesRequest groupCount(Long groupCount) {
        this.groupCount = groupCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of groups to return in the result.")
    public Long getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(Long groupCount) {
        this.groupCount = groupCount;
    }

    public GroupsGetEntitiesRequest groupMemberAttributes(List<GroupsRequestedAttribute> groupMemberAttributes) {
        this.groupMemberAttributes = groupMemberAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<GroupsRequestedAttribute> getGroupMemberAttributes() {
        return this.groupMemberAttributes;
    }

    public void setGroupMemberAttributes(List<GroupsRequestedAttribute> groupMemberAttributes) {
        this.groupMemberAttributes = groupMemberAttributes;
    }

    public GroupsGetEntitiesRequest groupMemberCount(Long groupMemberCount) {
        this.groupMemberCount = groupMemberCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of members to return per group.")
    public Long getGroupMemberCount() {
        return this.groupMemberCount;
    }

    public void setGroupMemberCount(Long groupMemberCount) {
        this.groupMemberCount = groupMemberCount;
    }

    public GroupsGetEntitiesRequest groupMemberOffset(Long groupMemberOffset) {
        this.groupMemberOffset = groupMemberOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="The offset into the total member set to return per group.")
    public Long getGroupMemberOffset() {
        return this.groupMemberOffset;
    }

    public void setGroupMemberOffset(Long groupMemberOffset) {
        this.groupMemberOffset = groupMemberOffset;
    }

    public GroupsGetEntitiesRequest groupMemberSortAttribute(String groupMemberSortAttribute) {
        this.groupMemberSortAttribute = groupMemberSortAttribute;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the attribute that will be used to sort group members. ")
    public String getGroupMemberSortAttribute() {
        return this.groupMemberSortAttribute;
    }

    public void setGroupMemberSortAttribute(String groupMemberSortAttribute) {
        this.groupMemberSortAttribute = groupMemberSortAttribute;
    }

    public GroupsGetEntitiesRequest groupMemberSortDownsamplingFunction(GroupsSortDownsamplingFunction groupMemberSortDownsamplingFunction) {
        this.groupMemberSortDownsamplingFunction = groupMemberSortDownsamplingFunction;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GroupsSortDownsamplingFunction getGroupMemberSortDownsamplingFunction() {
        return this.groupMemberSortDownsamplingFunction;
    }

    public void setGroupMemberSortDownsamplingFunction(GroupsSortDownsamplingFunction groupMemberSortDownsamplingFunction) {
        this.groupMemberSortDownsamplingFunction = groupMemberSortDownsamplingFunction;
    }

    public GroupsGetEntitiesRequest groupMemberSortOrder(GroupsSortOrder groupMemberSortOrder) {
        this.groupMemberSortOrder = groupMemberSortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GroupsSortOrder getGroupMemberSortOrder() {
        return this.groupMemberSortOrder;
    }

    public void setGroupMemberSortOrder(GroupsSortOrder groupMemberSortOrder) {
        this.groupMemberSortOrder = groupMemberSortOrder;
    }

    public GroupsGetEntitiesRequest groupOffset(Long groupOffset) {
        this.groupOffset = groupOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="The offset into the total set of groups to return.")
    public Long getGroupOffset() {
        return this.groupOffset;
    }

    public void setGroupOffset(Long groupOffset) {
        this.groupOffset = groupOffset;
    }

    public GroupsGetEntitiesRequest groupSortAttribute(String groupSortAttribute) {
        this.groupSortAttribute = groupSortAttribute;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the attribute that will be used to sort groups. ")
    public String getGroupSortAttribute() {
        return this.groupSortAttribute;
    }

    public void setGroupSortAttribute(String groupSortAttribute) {
        this.groupSortAttribute = groupSortAttribute;
    }

    public GroupsGetEntitiesRequest groupSortDownsampleFunction(GroupsSortDownsamplingFunction groupSortDownsampleFunction) {
        this.groupSortDownsampleFunction = groupSortDownsampleFunction;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GroupsSortDownsamplingFunction getGroupSortDownsampleFunction() {
        return this.groupSortDownsampleFunction;
    }

    public void setGroupSortDownsampleFunction(GroupsSortDownsamplingFunction groupSortDownsampleFunction) {
        this.groupSortDownsampleFunction = groupSortDownsampleFunction;
    }

    public GroupsGetEntitiesRequest groupSortOrder(GroupsSortOrder groupSortOrder) {
        this.groupSortOrder = groupSortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GroupsSortOrder getGroupSortOrder() {
        return this.groupSortOrder;
    }

    public void setGroupSortOrder(GroupsSortOrder groupSortOrder) {
        this.groupSortOrder = groupSortOrder;
    }

    public GroupsGetEntitiesRequest groupingAttribute(String groupingAttribute) {
        this.groupingAttribute = groupingAttribute;
        return this;
    }

    @ApiModelProperty(example="null", value="Attribute that will be used to perform a group-by if needed. ")
    public String getGroupingAttribute() {
        return this.groupingAttribute;
    }

    public void setGroupingAttribute(String groupingAttribute) {
        this.groupingAttribute = groupingAttribute;
    }

    public GroupsGetEntitiesRequest groupingAttributeType(GroupsAttributeType groupingAttributeType) {
        this.groupingAttributeType = groupingAttributeType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GroupsAttributeType getGroupingAttributeType() {
        return this.groupingAttributeType;
    }

    public void setGroupingAttributeType(GroupsAttributeType groupingAttributeType) {
        this.groupingAttributeType = groupingAttributeType;
    }

    public GroupsGetEntitiesRequest intervalEndMs(Long intervalEndMs) {
        this.intervalEndMs = intervalEndMs;
        return this;
    }

    @ApiModelProperty(example="null", value="For a time-series query, the end of the interval since the epoch in ms. Default is latest value only. ")
    public Long getIntervalEndMs() {
        return this.intervalEndMs;
    }

    public void setIntervalEndMs(Long intervalEndMs) {
        this.intervalEndMs = intervalEndMs;
    }

    public GroupsGetEntitiesRequest intervalStartMs(Long intervalStartMs) {
        this.intervalStartMs = intervalStartMs;
        return this;
    }

    @ApiModelProperty(example="null", value="For a time-series query, the start of the interval since the epoch in ms. Default is latest value only. ")
    public Long getIntervalStartMs() {
        return this.intervalStartMs;
    }

    public void setIntervalStartMs(Long intervalStartMs) {
        this.intervalStartMs = intervalStartMs;
    }

    public GroupsGetEntitiesRequest numberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        return this;
    }

    @ApiModelProperty(example="null", value="For grouping, how many groups to return.")
    public Integer getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public void setNumberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
    }

    public GroupsGetEntitiesRequest numberOfIntervalsForLatestData(Integer numberOfIntervalsForLatestData) {
        this.numberOfIntervalsForLatestData = numberOfIntervalsForLatestData;
        return this;
    }

    @ApiModelProperty(example="null", value="When retrieving latest values, how far back to look as a multiple of the downsampling interval for the metric. ")
    public Integer getNumberOfIntervalsForLatestData() {
        return this.numberOfIntervalsForLatestData;
    }

    public void setNumberOfIntervalsForLatestData(Integer numberOfIntervalsForLatestData) {
        this.numberOfIntervalsForLatestData = numberOfIntervalsForLatestData;
    }

    public GroupsGetEntitiesRequest queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @ApiModelProperty(example="null", value="A custom name to use for tagging the query when debugging.")
    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupsGetEntitiesRequest groupsGetEntitiesRequest = (GroupsGetEntitiesRequest)o;
        return Objects.equals(this.bucketBoundary, groupsGetEntitiesRequest.bucketBoundary) && Objects.equals(this.downsamplingInterval, groupsGetEntitiesRequest.downsamplingInterval) && Objects.equals(this.entityIds, groupsGetEntitiesRequest.entityIds) && Objects.equals(this.entityType, groupsGetEntitiesRequest.entityType) && Objects.equals(this.filterCriteria, groupsGetEntitiesRequest.filterCriteria) && Objects.equals(this.groupAttributes, groupsGetEntitiesRequest.groupAttributes) && Objects.equals(this.groupCount, groupsGetEntitiesRequest.groupCount) && Objects.equals(this.groupMemberAttributes, groupsGetEntitiesRequest.groupMemberAttributes) && Objects.equals(this.groupMemberCount, groupsGetEntitiesRequest.groupMemberCount) && Objects.equals(this.groupMemberOffset, groupsGetEntitiesRequest.groupMemberOffset) && Objects.equals(this.groupMemberSortAttribute, groupsGetEntitiesRequest.groupMemberSortAttribute) && Objects.equals(this.groupMemberSortDownsamplingFunction, groupsGetEntitiesRequest.groupMemberSortDownsamplingFunction) && Objects.equals(this.groupMemberSortOrder, groupsGetEntitiesRequest.groupMemberSortOrder) && Objects.equals(this.groupOffset, groupsGetEntitiesRequest.groupOffset) && Objects.equals(this.groupSortAttribute, groupsGetEntitiesRequest.groupSortAttribute) && Objects.equals(this.groupSortDownsampleFunction, groupsGetEntitiesRequest.groupSortDownsampleFunction) && Objects.equals(this.groupSortOrder, groupsGetEntitiesRequest.groupSortOrder) && Objects.equals(this.groupingAttribute, groupsGetEntitiesRequest.groupingAttribute) && Objects.equals(this.groupingAttributeType, groupsGetEntitiesRequest.groupingAttributeType) && Objects.equals(this.intervalEndMs, groupsGetEntitiesRequest.intervalEndMs) && Objects.equals(this.intervalStartMs, groupsGetEntitiesRequest.intervalStartMs) && Objects.equals(this.numberOfBuckets, groupsGetEntitiesRequest.numberOfBuckets) && Objects.equals(this.numberOfIntervalsForLatestData, groupsGetEntitiesRequest.numberOfIntervalsForLatestData) && Objects.equals(this.queryName, groupsGetEntitiesRequest.queryName);
    }

    public int hashCode() {
        return Objects.hash(this.bucketBoundary, this.downsamplingInterval, this.entityIds, this.entityType, this.filterCriteria, this.groupAttributes, this.groupCount, this.groupMemberAttributes, this.groupMemberCount, this.groupMemberOffset, this.groupMemberSortAttribute, this.groupMemberSortDownsamplingFunction, this.groupMemberSortOrder, this.groupOffset, this.groupSortAttribute, this.groupSortDownsampleFunction, this.groupSortOrder, this.groupingAttribute, this.groupingAttributeType, this.intervalEndMs, this.intervalStartMs, this.numberOfBuckets, this.numberOfIntervalsForLatestData, this.queryName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupsGetEntitiesRequest {\n");
        sb.append("    bucketBoundary: ").append(this.toIndentedString(this.bucketBoundary)).append("\n");
        sb.append("    downsamplingInterval: ").append(this.toIndentedString(this.downsamplingInterval)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    filterCriteria: ").append(this.toIndentedString(this.filterCriteria)).append("\n");
        sb.append("    groupAttributes: ").append(this.toIndentedString(this.groupAttributes)).append("\n");
        sb.append("    groupCount: ").append(this.toIndentedString(this.groupCount)).append("\n");
        sb.append("    groupMemberAttributes: ").append(this.toIndentedString(this.groupMemberAttributes)).append("\n");
        sb.append("    groupMemberCount: ").append(this.toIndentedString(this.groupMemberCount)).append("\n");
        sb.append("    groupMemberOffset: ").append(this.toIndentedString(this.groupMemberOffset)).append("\n");
        sb.append("    groupMemberSortAttribute: ").append(this.toIndentedString(this.groupMemberSortAttribute)).append("\n");
        sb.append("    groupMemberSortDownsamplingFunction: ").append(this.toIndentedString(this.groupMemberSortDownsamplingFunction)).append("\n");
        sb.append("    groupMemberSortOrder: ").append(this.toIndentedString(this.groupMemberSortOrder)).append("\n");
        sb.append("    groupOffset: ").append(this.toIndentedString(this.groupOffset)).append("\n");
        sb.append("    groupSortAttribute: ").append(this.toIndentedString(this.groupSortAttribute)).append("\n");
        sb.append("    groupSortDownsampleFunction: ").append(this.toIndentedString(this.groupSortDownsampleFunction)).append("\n");
        sb.append("    groupSortOrder: ").append(this.toIndentedString(this.groupSortOrder)).append("\n");
        sb.append("    groupingAttribute: ").append(this.toIndentedString(this.groupingAttribute)).append("\n");
        sb.append("    groupingAttributeType: ").append(this.toIndentedString(this.groupingAttributeType)).append("\n");
        sb.append("    intervalEndMs: ").append(this.toIndentedString(this.intervalEndMs)).append("\n");
        sb.append("    intervalStartMs: ").append(this.toIndentedString(this.intervalStartMs)).append("\n");
        sb.append("    numberOfBuckets: ").append(this.toIndentedString(this.numberOfBuckets)).append("\n");
        sb.append("    numberOfIntervalsForLatestData: ").append(this.toIndentedString(this.numberOfIntervalsForLatestData)).append("\n");
        sb.append("    queryName: ").append(this.toIndentedString(this.queryName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

