/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Docker registry resources")
public class DockerRegistryResources {
    @SerializedName(value="certificate")
    private String certificate = null;
    @SerializedName(value="is_enabled")
    private Boolean isEnabled = null;
    @SerializedName(value="is_system_default")
    private Boolean isSystemDefault = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="username")
    private String username = null;

    public DockerRegistryResources certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @ApiModelProperty(example="null", value="Certificate required for the private docker registry")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public DockerRegistryResources isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether the docker registry is enabled or not. If unset, defaults to False. ")
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether the docker registry is a system default ")
    public Boolean getIsSystemDefault() {
        return this.isSystemDefault;
    }

    public DockerRegistryResources password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Password of the user for the docker registry")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DockerRegistryResources url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL of the docker registry")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DockerRegistryResources username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User name of the docker registry")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerRegistryResources dockerRegistryResources = (DockerRegistryResources)o;
        return Objects.equals(this.certificate, dockerRegistryResources.certificate) && Objects.equals(this.isEnabled, dockerRegistryResources.isEnabled) && Objects.equals(this.isSystemDefault, dockerRegistryResources.isSystemDefault) && Objects.equals(this.password, dockerRegistryResources.password) && Objects.equals(this.url, dockerRegistryResources.url) && Objects.equals(this.username, dockerRegistryResources.username);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.isEnabled, this.isSystemDefault, this.password, this.url, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DockerRegistryResources {\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isSystemDefault: ").append(this.toIndentedString(this.isSystemDefault)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

