/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="Docker Hub tagged image")
public class DockerRegistryImageTag {
    @SerializedName(value="modified_date")
    private DateTime modifiedDate = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="size_mib")
    private Long sizeMib = null;

    public DockerRegistryImageTag modifiedDate(DateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Last modified date in RFC 3339")
    public DateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(DateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public DockerRegistryImageTag name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Image tag name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DockerRegistryImageTag sizeMib(Long sizeMib) {
        this.sizeMib = sizeMib;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Size of the image in MiB")
    public Long getSizeMib() {
        return this.sizeMib;
    }

    public void setSizeMib(Long sizeMib) {
        this.sizeMib = sizeMib;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerRegistryImageTag dockerRegistryImageTag = (DockerRegistryImageTag)o;
        return Objects.equals(this.modifiedDate, dockerRegistryImageTag.modifiedDate) && Objects.equals(this.name, dockerRegistryImageTag.name) && Objects.equals(this.sizeMib, dockerRegistryImageTag.sizeMib);
    }

    public int hashCode() {
        return Objects.hash(this.modifiedDate, this.name, this.sizeMib);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DockerRegistryImageTag {\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sizeMib: ").append(this.toIndentedString(this.sizeMib)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

