/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.DockerRegistryImageTag;

@ApiModel(description="Docker registry image search result")
public class DockerRegistryImageStatus {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="is_official")
    private Boolean isOfficial = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner")
    private String owner = null;
    @SerializedName(value="tag_list")
    private List<DockerRegistryImageTag> tagList = new ArrayList<DockerRegistryImageTag>();

    public DockerRegistryImageStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Repository description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DockerRegistryImageStatus isOfficial(Boolean isOfficial) {
        this.isOfficial = isOfficial;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether it is an official Docker Hub image")
    public Boolean getIsOfficial() {
        return this.isOfficial;
    }

    public void setIsOfficial(Boolean isOfficial) {
        this.isOfficial = isOfficial;
    }

    public DockerRegistryImageStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Repository name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DockerRegistryImageStatus owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Owner user name")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public DockerRegistryImageStatus tagList(List<DockerRegistryImageTag> tagList) {
        this.tagList = tagList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public List<DockerRegistryImageTag> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<DockerRegistryImageTag> tagList) {
        this.tagList = tagList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerRegistryImageStatus dockerRegistryImageStatus = (DockerRegistryImageStatus)o;
        return Objects.equals(this.description, dockerRegistryImageStatus.description) && Objects.equals(this.isOfficial, dockerRegistryImageStatus.isOfficial) && Objects.equals(this.name, dockerRegistryImageStatus.name) && Objects.equals(this.owner, dockerRegistryImageStatus.owner) && Objects.equals(this.tagList, dockerRegistryImageStatus.tagList);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.isOfficial, this.name, this.owner, this.tagList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DockerRegistryImageStatus {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isOfficial: ").append(this.toIndentedString(this.isOfficial)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    tagList: ").append(this.toIndentedString(this.tagList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

