/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.Reference;

@ApiModel(description="Disk resources.")
public class DiskDefStatusResources {
    @SerializedName(value="enabled_features_list")
    private List<String> enabledFeaturesList = new ArrayList<String>();
    @SerializedName(value="firmware_version")
    private String firmwareVersion = null;
    @SerializedName(value="host_reference")
    private Reference hostReference = null;
    @SerializedName(value="model")
    private String model = null;
    @SerializedName(value="mount_path")
    private String mountPath = null;
    @SerializedName(value="serial_number")
    private String serialNumber = null;
    @SerializedName(value="size_bytes")
    private Long sizeBytes = null;
    @SerializedName(value="slot_number")
    private Integer slotNumber = null;
    @SerializedName(value="state_list")
    private List<String> stateList = new ArrayList<String>();
    @SerializedName(value="storage_pool_uuid")
    private String storagePoolUuid = null;
    @SerializedName(value="storage_tier_type")
    private String storageTierType = null;
    @SerializedName(value="vendor")
    private String vendor = null;

    public DiskDefStatusResources enabledFeaturesList(List<String> enabledFeaturesList) {
        this.enabledFeaturesList = enabledFeaturesList;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk feature flags - 'CanAddAsNewDisk': Flag to indicate if this disk can be added as    new disk. - 'CanAddAsOldDisk': Flag to indicate if the disk can be added as    old disk. - 'BootDisk': Flag to indicate if its a boot disk. - 'OnlyBootDisk': Flag to indicate if the disk is boot only and    no disk operation to be run on it. - 'SelfEncryptingEnabled': Flag to indicate if the disk has self    encryption enabled. - 'PasswordProtected': Flag to indicate if the disk is password    protected. ")
    public List<String> getEnabledFeaturesList() {
        return this.enabledFeaturesList;
    }

    public void setEnabledFeaturesList(List<String> enabledFeaturesList) {
        this.enabledFeaturesList = enabledFeaturesList;
    }

    public DiskDefStatusResources firmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Firmware version.")
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public DiskDefStatusResources hostReference(Reference hostReference) {
        this.hostReference = hostReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getHostReference() {
        return this.hostReference;
    }

    public void setHostReference(Reference hostReference) {
        this.hostReference = hostReference;
    }

    public DiskDefStatusResources model(String model) {
        this.model = model;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk model.")
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public DiskDefStatusResources mountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @ApiModelProperty(example="null", value="Mount path.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public DiskDefStatusResources serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk serial number.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public DiskDefStatusResources sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk size in bytes.")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public DiskDefStatusResources slotNumber(Integer slotNumber) {
        this.slotNumber = slotNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk location in a node.")
    public Integer getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(Integer slotNumber) {
        this.slotNumber = slotNumber;
    }

    public DiskDefStatusResources stateList(List<String> stateList) {
        this.stateList = stateList;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of disk states - DataMigrationInitiated: Data Migration Initiated. - MarkedForRemovalButNotDetachable: Marked for removal, data    migration is in progress. - ReadyToDetach: Flag to indicate the disk is detachable. - DataMigrated: Flag to indicate if data migration is completed for    this disk. - MarkedForRemoval: Flag to indicate if the disk is marked for    removal. - Online: Flag to indicate if the disk is online. - Bad: Flag to indicate if the disk is bad. - Mounted: Flag to indicate if the disk is mounted. - UnderDiagnosis: Flag to indicate if the disk is under diagnosis. ")
    public List<String> getStateList() {
        return this.stateList;
    }

    public void setStateList(List<String> stateList) {
        this.stateList = stateList;
    }

    public DiskDefStatusResources storagePoolUuid(String storagePoolUuid) {
        this.storagePoolUuid = storagePoolUuid;
        return this;
    }

    @ApiModelProperty(example="null", value="Storage pool uuid.")
    public String getStoragePoolUuid() {
        return this.storagePoolUuid;
    }

    public void setStoragePoolUuid(String storagePoolUuid) {
        this.storagePoolUuid = storagePoolUuid;
    }

    public DiskDefStatusResources storageTierType(String storageTierType) {
        this.storageTierType = storageTierType;
        return this;
    }

    @ApiModelProperty(example="null", value="Storage tier type.")
    public String getStorageTierType() {
        return this.storageTierType;
    }

    public void setStorageTierType(String storageTierType) {
        this.storageTierType = storageTierType;
    }

    public DiskDefStatusResources vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @ApiModelProperty(example="null", value="Disk vendor.")
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskDefStatusResources diskDefStatusResources = (DiskDefStatusResources)o;
        return Objects.equals(this.enabledFeaturesList, diskDefStatusResources.enabledFeaturesList) && Objects.equals(this.firmwareVersion, diskDefStatusResources.firmwareVersion) && Objects.equals(this.hostReference, diskDefStatusResources.hostReference) && Objects.equals(this.model, diskDefStatusResources.model) && Objects.equals(this.mountPath, diskDefStatusResources.mountPath) && Objects.equals(this.serialNumber, diskDefStatusResources.serialNumber) && Objects.equals(this.sizeBytes, diskDefStatusResources.sizeBytes) && Objects.equals(this.slotNumber, diskDefStatusResources.slotNumber) && Objects.equals(this.stateList, diskDefStatusResources.stateList) && Objects.equals(this.storagePoolUuid, diskDefStatusResources.storagePoolUuid) && Objects.equals(this.storageTierType, diskDefStatusResources.storageTierType) && Objects.equals(this.vendor, diskDefStatusResources.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.enabledFeaturesList, this.firmwareVersion, this.hostReference, this.model, this.mountPath, this.serialNumber, this.sizeBytes, this.slotNumber, this.stateList, this.storagePoolUuid, this.storageTierType, this.vendor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DiskDefStatusResources {\n");
        sb.append("    enabledFeaturesList: ").append(this.toIndentedString(this.enabledFeaturesList)).append("\n");
        sb.append("    firmwareVersion: ").append(this.toIndentedString(this.firmwareVersion)).append("\n");
        sb.append("    hostReference: ").append(this.toIndentedString(this.hostReference)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    slotNumber: ").append(this.toIndentedString(this.slotNumber)).append("\n");
        sb.append("    stateList: ").append(this.toIndentedString(this.stateList)).append("\n");
        sb.append("    storagePoolUuid: ").append(this.toIndentedString(this.storagePoolUuid)).append("\n");
        sb.append("    storageTierType: ").append(this.toIndentedString(this.storageTierType)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

