/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.DirectoryServiceSearchMetadata;
import nutanix.model.Entity;

@ApiModel(description="The response returned for directory service search operation.")
public class DirectoryServiceSearchResponse {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="domain_name")
    private String domainName = null;
    @SerializedName(value="metadata")
    private DirectoryServiceSearchMetadata metadata = null;
    @SerializedName(value="search_result_list")
    private List<Entity> searchResultList = new ArrayList<Entity>();

    public DirectoryServiceSearchResponse apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The current API version.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public DirectoryServiceSearchResponse domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", value="The domain name of the directory service.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DirectoryServiceSearchResponse metadata(DirectoryServiceSearchMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DirectoryServiceSearchMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DirectoryServiceSearchMetadata metadata) {
        this.metadata = metadata;
    }

    public DirectoryServiceSearchResponse searchResultList(List<Entity> searchResultList) {
        this.searchResultList = searchResultList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<Entity> getSearchResultList() {
        return this.searchResultList;
    }

    public void setSearchResultList(List<Entity> searchResultList) {
        this.searchResultList = searchResultList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryServiceSearchResponse directoryServiceSearchResponse = (DirectoryServiceSearchResponse)o;
        return Objects.equals(this.apiVersion, directoryServiceSearchResponse.apiVersion) && Objects.equals(this.domainName, directoryServiceSearchResponse.domainName) && Objects.equals(this.metadata, directoryServiceSearchResponse.metadata) && Objects.equals(this.searchResultList, directoryServiceSearchResponse.searchResultList);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.domainName, this.metadata, this.searchResultList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectoryServiceSearchResponse {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    searchResultList: ").append(this.toIndentedString(this.searchResultList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

