/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The parameters to search for directory service.")
public class DirectoryServiceSearchMetadata {
    @SerializedName(value="query")
    private String query = null;
    @SerializedName(value="returned_attribute_list")
    private List<String> returnedAttributeList = new ArrayList<String>();
    @SerializedName(value="searched_attribute_list")
    private List<String> searchedAttributeList = new ArrayList<String>();

    public DirectoryServiceSearchMetadata query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The search string.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public DirectoryServiceSearchMetadata returnedAttributeList(List<String> returnedAttributeList) {
        this.returnedAttributeList = returnedAttributeList;
        return this;
    }

    @ApiModelProperty(example="null", value="The attributes the search operation returns. If not available, a list of default attributes is returned. ")
    public List<String> getReturnedAttributeList() {
        return this.returnedAttributeList;
    }

    public void setReturnedAttributeList(List<String> returnedAttributeList) {
        this.returnedAttributeList = returnedAttributeList;
    }

    public DirectoryServiceSearchMetadata searchedAttributeList(List<String> searchedAttributeList) {
        this.searchedAttributeList = searchedAttributeList;
        return this;
    }

    @ApiModelProperty(example="null", value="The attributes for search operation. If not specified, search is performed with the common name. ")
    public List<String> getSearchedAttributeList() {
        return this.searchedAttributeList;
    }

    public void setSearchedAttributeList(List<String> searchedAttributeList) {
        this.searchedAttributeList = searchedAttributeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryServiceSearchMetadata directoryServiceSearchMetadata = (DirectoryServiceSearchMetadata)o;
        return Objects.equals(this.query, directoryServiceSearchMetadata.query) && Objects.equals(this.returnedAttributeList, directoryServiceSearchMetadata.returnedAttributeList) && Objects.equals(this.searchedAttributeList, directoryServiceSearchMetadata.searchedAttributeList);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.returnedAttributeList, this.searchedAttributeList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectoryServiceSearchMetadata {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    returnedAttributeList: ").append(this.toIndentedString(this.returnedAttributeList)).append("\n");
        sb.append("    searchedAttributeList: ").append(this.toIndentedString(this.searchedAttributeList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

