/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ServiceAccount;
import nutanix.model.UserReferenceWithName;

@ApiModel(description="The details of the directory service.")
public class DirectoryServiceResources {
    @SerializedName(value="admin_group_list")
    private List<String> adminGroupList = new ArrayList<String>();
    @SerializedName(value="admin_user_reference_list")
    private List<UserReferenceWithName> adminUserReferenceList = new ArrayList<UserReferenceWithName>();
    @SerializedName(value="directory_type")
    private String directoryType = null;
    @SerializedName(value="domain_name")
    private String domainName = null;
    @SerializedName(value="service_account")
    private ServiceAccount serviceAccount = null;
    @SerializedName(value="url")
    private String url = null;

    public DirectoryServiceResources adminGroupList(List<String> adminGroupList) {
        this.adminGroupList = adminGroupList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of distinguished names of the admin group in the directory service. ")
    public List<String> getAdminGroupList() {
        return this.adminGroupList;
    }

    public void setAdminGroupList(List<String> adminGroupList) {
        this.adminGroupList = adminGroupList;
    }

    public DirectoryServiceResources adminUserReferenceList(List<UserReferenceWithName> adminUserReferenceList) {
        this.adminUserReferenceList = adminUserReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of admin users available in the directory service. ")
    public List<UserReferenceWithName> getAdminUserReferenceList() {
        return this.adminUserReferenceList;
    }

    public void setAdminUserReferenceList(List<UserReferenceWithName> adminUserReferenceList) {
        this.adminUserReferenceList = adminUserReferenceList;
    }

    public DirectoryServiceResources directoryType(String directoryType) {
        this.directoryType = directoryType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of the directory service.")
    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public DirectoryServiceResources domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The domain name of the directory service.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DirectoryServiceResources serviceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public DirectoryServiceResources url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL of the directory.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryServiceResources directoryServiceResources = (DirectoryServiceResources)o;
        return Objects.equals(this.adminGroupList, directoryServiceResources.adminGroupList) && Objects.equals(this.adminUserReferenceList, directoryServiceResources.adminUserReferenceList) && Objects.equals(this.directoryType, directoryServiceResources.directoryType) && Objects.equals(this.domainName, directoryServiceResources.domainName) && Objects.equals(this.serviceAccount, directoryServiceResources.serviceAccount) && Objects.equals(this.url, directoryServiceResources.url);
    }

    public int hashCode() {
        return Objects.hash(this.adminGroupList, this.adminUserReferenceList, this.directoryType, this.domainName, this.serviceAccount, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectoryServiceResources {\n");
        sb.append("    adminGroupList: ").append(this.toIndentedString(this.adminGroupList)).append("\n");
        sb.append("    adminUserReferenceList: ").append(this.toIndentedString(this.adminUserReferenceList)).append("\n");
        sb.append("    directoryType: ").append(this.toIndentedString(this.directoryType)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

