/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ServiceAccount;
import nutanix.model.UserGroup;
import nutanix.model.UserReferenceWithName;

@ApiModel(description="The configuration details of the directory service.")
public class DirectoryServiceDefStatusResources {
    @SerializedName(value="admin_group_list")
    private List<UserGroup> adminGroupList = new ArrayList<UserGroup>();
    @SerializedName(value="admin_user_reference_list")
    private List<UserReferenceWithName> adminUserReferenceList = new ArrayList<UserReferenceWithName>();
    @SerializedName(value="directory_type")
    private String directoryType = null;
    @SerializedName(value="domain_name")
    private String domainName = null;
    @SerializedName(value="service_account")
    private ServiceAccount serviceAccount = null;
    @SerializedName(value="url")
    private String url = null;

    public DirectoryServiceDefStatusResources adminGroupList(List<UserGroup> adminGroupList) {
        this.adminGroupList = adminGroupList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of distinguished names of the admin group in the directory service. ")
    public List<UserGroup> getAdminGroupList() {
        return this.adminGroupList;
    }

    public void setAdminGroupList(List<UserGroup> adminGroupList) {
        this.adminGroupList = adminGroupList;
    }

    public DirectoryServiceDefStatusResources adminUserReferenceList(List<UserReferenceWithName> adminUserReferenceList) {
        this.adminUserReferenceList = adminUserReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of admin users available in the directory service. ")
    public List<UserReferenceWithName> getAdminUserReferenceList() {
        return this.adminUserReferenceList;
    }

    public void setAdminUserReferenceList(List<UserReferenceWithName> adminUserReferenceList) {
        this.adminUserReferenceList = adminUserReferenceList;
    }

    public DirectoryServiceDefStatusResources directoryType(String directoryType) {
        this.directoryType = directoryType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of the directory service.")
    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.directoryType = directoryType;
    }

    public DirectoryServiceDefStatusResources domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The domain name of the directory service.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DirectoryServiceDefStatusResources serviceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @ApiModelProperty(example="null", value="Validates and connects to the directory service with the given credentials. ")
    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public DirectoryServiceDefStatusResources url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL of the directory.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryServiceDefStatusResources directoryServiceDefStatusResources = (DirectoryServiceDefStatusResources)o;
        return Objects.equals(this.adminGroupList, directoryServiceDefStatusResources.adminGroupList) && Objects.equals(this.adminUserReferenceList, directoryServiceDefStatusResources.adminUserReferenceList) && Objects.equals(this.directoryType, directoryServiceDefStatusResources.directoryType) && Objects.equals(this.domainName, directoryServiceDefStatusResources.domainName) && Objects.equals(this.serviceAccount, directoryServiceDefStatusResources.serviceAccount) && Objects.equals(this.url, directoryServiceDefStatusResources.url);
    }

    public int hashCode() {
        return Objects.hash(this.adminGroupList, this.adminUserReferenceList, this.directoryType, this.domainName, this.serviceAccount, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectoryServiceDefStatusResources {\n");
        sb.append("    adminGroupList: ").append(this.toIndentedString(this.adminGroupList)).append("\n");
        sb.append("    adminUserReferenceList: ").append(this.toIndentedString(this.adminUserReferenceList)).append("\n");
        sb.append("    directoryType: ").append(this.toIndentedString(this.directoryType)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

