/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Spec for defining DHCP options.")
public class DhcpOptions {
    @SerializedName(value="boot_file_name")
    private String bootFileName = null;
    @SerializedName(value="domain_name")
    private String domainName = null;
    @SerializedName(value="domain_name_server_list")
    private List<String> domainNameServerList = new ArrayList<String>();
    @SerializedName(value="domain_search_list")
    private List<String> domainSearchList = new ArrayList<String>();
    @SerializedName(value="tftp_server_name")
    private String tftpServerName = null;

    public DhcpOptions bootFileName(String bootFileName) {
        this.bootFileName = bootFileName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getBootFileName() {
        return this.bootFileName;
    }

    public void setBootFileName(String bootFileName) {
        this.bootFileName = bootFileName;
    }

    public DhcpOptions domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DhcpOptions domainNameServerList(List<String> domainNameServerList) {
        this.domainNameServerList = domainNameServerList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<String> getDomainNameServerList() {
        return this.domainNameServerList;
    }

    public void setDomainNameServerList(List<String> domainNameServerList) {
        this.domainNameServerList = domainNameServerList;
    }

    public DhcpOptions domainSearchList(List<String> domainSearchList) {
        this.domainSearchList = domainSearchList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<String> getDomainSearchList() {
        return this.domainSearchList;
    }

    public void setDomainSearchList(List<String> domainSearchList) {
        this.domainSearchList = domainSearchList;
    }

    public DhcpOptions tftpServerName(String tftpServerName) {
        this.tftpServerName = tftpServerName;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getTftpServerName() {
        return this.tftpServerName;
    }

    public void setTftpServerName(String tftpServerName) {
        this.tftpServerName = tftpServerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DhcpOptions dhcpOptions = (DhcpOptions)o;
        return Objects.equals(this.bootFileName, dhcpOptions.bootFileName) && Objects.equals(this.domainName, dhcpOptions.domainName) && Objects.equals(this.domainNameServerList, dhcpOptions.domainNameServerList) && Objects.equals(this.domainSearchList, dhcpOptions.domainSearchList) && Objects.equals(this.tftpServerName, dhcpOptions.tftpServerName);
    }

    public int hashCode() {
        return Objects.hash(this.bootFileName, this.domainName, this.domainNameServerList, this.domainSearchList, this.tftpServerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DhcpOptions {\n");
        sb.append("    bootFileName: ").append(this.toIndentedString(this.bootFileName)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    domainNameServerList: ").append(this.toIndentedString(this.domainNameServerList)).append("\n");
        sb.append("    domainSearchList: ").append(this.toIndentedString(this.domainSearchList)).append("\n");
        sb.append("    tftpServerName: ").append(this.toIndentedString(this.tftpServerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

