/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ContainerOptionsStatus;
import nutanix.model.DockerRegistryReference;
import nutanix.model.SubnetReference;
import nutanix.model.VolumeGroupDefStatus;
import nutanix.model.VolumeGroupReference;

@ApiModel(description="Container Resources Status Definition.")
public class ContainerResourcesDefStatus {
    @SerializedName(value="container_options")
    private ContainerOptionsStatus containerOptions = null;
    @SerializedName(value="container_state")
    private String containerState = null;
    @SerializedName(value="image_name")
    private String imageName = null;
    @SerializedName(value="registry_reference")
    private DockerRegistryReference registryReference = null;
    @SerializedName(value="runtime_name")
    private String runtimeName = null;
    @SerializedName(value="subnet_reference_list")
    private List<SubnetReference> subnetReferenceList = new ArrayList<SubnetReference>();
    @SerializedName(value="volume_list")
    private List<VolumeGroupDefStatus> volumeList = new ArrayList<VolumeGroupDefStatus>();
    @SerializedName(value="volume_reference_list")
    private List<VolumeGroupReference> volumeReferenceList = new ArrayList<VolumeGroupReference>();

    public ContainerResourcesDefStatus containerOptions(ContainerOptionsStatus containerOptions) {
        this.containerOptions = containerOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Various options for container.")
    public ContainerOptionsStatus getContainerOptions() {
        return this.containerOptions;
    }

    public void setContainerOptions(ContainerOptionsStatus containerOptions) {
        this.containerOptions = containerOptions;
    }

    public ContainerResourcesDefStatus containerState(String containerState) {
        this.containerState = containerState;
        return this;
    }

    @ApiModelProperty(example="null", value="Current state of the Container.")
    public String getContainerState() {
        return this.containerState;
    }

    public void setContainerState(String containerState) {
        this.containerState = containerState;
    }

    public ContainerResourcesDefStatus imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Image name used for container.")
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public ContainerResourcesDefStatus registryReference(DockerRegistryReference registryReference) {
        this.registryReference = registryReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to container registry.")
    public DockerRegistryReference getRegistryReference() {
        return this.registryReference;
    }

    public void setRegistryReference(DockerRegistryReference registryReference) {
        this.registryReference = registryReference;
    }

    public ContainerResourcesDefStatus runtimeName(String runtimeName) {
        this.runtimeName = runtimeName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of container given by runtime.")
    public String getRuntimeName() {
        return this.runtimeName;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public ContainerResourcesDefStatus subnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="Networks associated with this container.")
    public List<SubnetReference> getSubnetReferenceList() {
        return this.subnetReferenceList;
    }

    public void setSubnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
    }

    public ContainerResourcesDefStatus volumeList(List<VolumeGroupDefStatus> volumeList) {
        this.volumeList = volumeList;
        return this;
    }

    @ApiModelProperty(example="null", value="Volumes associated with this container.")
    public List<VolumeGroupDefStatus> getVolumeList() {
        return this.volumeList;
    }

    public void setVolumeList(List<VolumeGroupDefStatus> volumeList) {
        this.volumeList = volumeList;
    }

    public ContainerResourcesDefStatus volumeReferenceList(List<VolumeGroupReference> volumeReferenceList) {
        this.volumeReferenceList = volumeReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="Referenced Volumes associated with this container.")
    public List<VolumeGroupReference> getVolumeReferenceList() {
        return this.volumeReferenceList;
    }

    public void setVolumeReferenceList(List<VolumeGroupReference> volumeReferenceList) {
        this.volumeReferenceList = volumeReferenceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResourcesDefStatus containerResourcesDefStatus = (ContainerResourcesDefStatus)o;
        return Objects.equals(this.containerOptions, containerResourcesDefStatus.containerOptions) && Objects.equals(this.containerState, containerResourcesDefStatus.containerState) && Objects.equals(this.imageName, containerResourcesDefStatus.imageName) && Objects.equals(this.registryReference, containerResourcesDefStatus.registryReference) && Objects.equals(this.runtimeName, containerResourcesDefStatus.runtimeName) && Objects.equals(this.subnetReferenceList, containerResourcesDefStatus.subnetReferenceList) && Objects.equals(this.volumeList, containerResourcesDefStatus.volumeList) && Objects.equals(this.volumeReferenceList, containerResourcesDefStatus.volumeReferenceList);
    }

    public int hashCode() {
        return Objects.hash(this.containerOptions, this.containerState, this.imageName, this.registryReference, this.runtimeName, this.subnetReferenceList, this.volumeList, this.volumeReferenceList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerResourcesDefStatus {\n");
        sb.append("    containerOptions: ").append(this.toIndentedString(this.containerOptions)).append("\n");
        sb.append("    containerState: ").append(this.toIndentedString(this.containerState)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    registryReference: ").append(this.toIndentedString(this.registryReference)).append("\n");
        sb.append("    runtimeName: ").append(this.toIndentedString(this.runtimeName)).append("\n");
        sb.append("    subnetReferenceList: ").append(this.toIndentedString(this.subnetReferenceList)).append("\n");
        sb.append("    volumeList: ").append(this.toIndentedString(this.volumeList)).append("\n");
        sb.append("    volumeReferenceList: ").append(this.toIndentedString(this.volumeReferenceList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

