/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ContainerOptions;
import nutanix.model.DockerRegistryReference;
import nutanix.model.SubnetReference;
import nutanix.model.VolumeGroup;
import nutanix.model.VolumeGroupReference;

@ApiModel(description="Container Resources Definition.")
public class ContainerResources {
    @SerializedName(value="container_options")
    private ContainerOptions containerOptions = null;
    @SerializedName(value="container_state")
    private String containerState = null;
    @SerializedName(value="image_name")
    private String imageName = null;
    @SerializedName(value="registry_reference")
    private DockerRegistryReference registryReference = null;
    @SerializedName(value="subnet_reference_list")
    private List<SubnetReference> subnetReferenceList = new ArrayList<SubnetReference>();
    @SerializedName(value="volume_list")
    private List<VolumeGroup> volumeList = new ArrayList<VolumeGroup>();
    @SerializedName(value="volume_reference_list")
    private List<VolumeGroupReference> volumeReferenceList = new ArrayList<VolumeGroupReference>();

    public ContainerResources containerOptions(ContainerOptions containerOptions) {
        this.containerOptions = containerOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Various options for container.")
    public ContainerOptions getContainerOptions() {
        return this.containerOptions;
    }

    public void setContainerOptions(ContainerOptions containerOptions) {
        this.containerOptions = containerOptions;
    }

    public ContainerResources containerState(String containerState) {
        this.containerState = containerState;
        return this;
    }

    @ApiModelProperty(example="null", value="Desired state of the container.")
    public String getContainerState() {
        return this.containerState;
    }

    public void setContainerState(String containerState) {
        this.containerState = containerState;
    }

    public ContainerResources imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Image name to be used for container.")
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public ContainerResources registryReference(DockerRegistryReference registryReference) {
        this.registryReference = registryReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to container registry.")
    public DockerRegistryReference getRegistryReference() {
        return this.registryReference;
    }

    public void setRegistryReference(DockerRegistryReference registryReference) {
        this.registryReference = registryReference;
    }

    public ContainerResources subnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="Networks associated with this container.")
    public List<SubnetReference> getSubnetReferenceList() {
        return this.subnetReferenceList;
    }

    public void setSubnetReferenceList(List<SubnetReference> subnetReferenceList) {
        this.subnetReferenceList = subnetReferenceList;
    }

    public ContainerResources volumeList(List<VolumeGroup> volumeList) {
        this.volumeList = volumeList;
        return this;
    }

    @ApiModelProperty(example="null", value="Volumes associated with this container.")
    public List<VolumeGroup> getVolumeList() {
        return this.volumeList;
    }

    public void setVolumeList(List<VolumeGroup> volumeList) {
        this.volumeList = volumeList;
    }

    public ContainerResources volumeReferenceList(List<VolumeGroupReference> volumeReferenceList) {
        this.volumeReferenceList = volumeReferenceList;
        return this;
    }

    @ApiModelProperty(example="null", value="Referenced volumes associated with this container.")
    public List<VolumeGroupReference> getVolumeReferenceList() {
        return this.volumeReferenceList;
    }

    public void setVolumeReferenceList(List<VolumeGroupReference> volumeReferenceList) {
        this.volumeReferenceList = volumeReferenceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResources containerResources = (ContainerResources)o;
        return Objects.equals(this.containerOptions, containerResources.containerOptions) && Objects.equals(this.containerState, containerResources.containerState) && Objects.equals(this.imageName, containerResources.imageName) && Objects.equals(this.registryReference, containerResources.registryReference) && Objects.equals(this.subnetReferenceList, containerResources.subnetReferenceList) && Objects.equals(this.volumeList, containerResources.volumeList) && Objects.equals(this.volumeReferenceList, containerResources.volumeReferenceList);
    }

    public int hashCode() {
        return Objects.hash(this.containerOptions, this.containerState, this.imageName, this.registryReference, this.subnetReferenceList, this.volumeList, this.volumeReferenceList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerResources {\n");
        sb.append("    containerOptions: ").append(this.toIndentedString(this.containerOptions)).append("\n");
        sb.append("    containerState: ").append(this.toIndentedString(this.containerState)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    registryReference: ").append(this.toIndentedString(this.registryReference)).append("\n");
        sb.append("    subnetReferenceList: ").append(this.toIndentedString(this.subnetReferenceList)).append("\n");
        sb.append("    volumeList: ").append(this.toIndentedString(this.volumeList)).append("\n");
        sb.append("    volumeReferenceList: ").append(this.toIndentedString(this.volumeReferenceList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

