/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container options in use by the container")
public class ContainerOptionsStatus {
    @SerializedName(value="command")
    private String command = null;
    @SerializedName(value="container_additional_options")
    private String containerAdditionalOptions = null;
    @SerializedName(value="container_runtime")
    private String containerRuntime = null;
    @SerializedName(value="memory_mib")
    private Integer memoryMib = null;
    @SerializedName(value="num_cpu_shares")
    private Integer numCpuShares = null;
    @SerializedName(value="restart_policy")
    private String restartPolicy = null;

    public ContainerOptionsStatus command(String command) {
        this.command = command;
        return this;
    }

    @ApiModelProperty(example="null", value="Command to be executed for the container.")
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public ContainerOptionsStatus containerAdditionalOptions(String containerAdditionalOptions) {
        this.containerAdditionalOptions = containerAdditionalOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional options to be used for container.")
    public String getContainerAdditionalOptions() {
        return this.containerAdditionalOptions;
    }

    public void setContainerAdditionalOptions(String containerAdditionalOptions) {
        this.containerAdditionalOptions = containerAdditionalOptions;
    }

    public ContainerOptionsStatus containerRuntime(String containerRuntime) {
        this.containerRuntime = containerRuntime;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of container runtime.")
    public String getContainerRuntime() {
        return this.containerRuntime;
    }

    public void setContainerRuntime(String containerRuntime) {
        this.containerRuntime = containerRuntime;
    }

    public ContainerOptionsStatus memoryMib(Integer memoryMib) {
        this.memoryMib = memoryMib;
        return this;
    }

    @ApiModelProperty(example="null", value="Memory in MiBs.")
    public Integer getMemoryMib() {
        return this.memoryMib;
    }

    public void setMemoryMib(Integer memoryMib) {
        this.memoryMib = memoryMib;
    }

    public ContainerOptionsStatus numCpuShares(Integer numCpuShares) {
        this.numCpuShares = numCpuShares;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of cpu shares.")
    public Integer getNumCpuShares() {
        return this.numCpuShares;
    }

    public void setNumCpuShares(Integer numCpuShares) {
        this.numCpuShares = numCpuShares;
    }

    public ContainerOptionsStatus restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @ApiModelProperty(example="null", value="Container restart policy.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerOptionsStatus containerOptionsStatus = (ContainerOptionsStatus)o;
        return Objects.equals(this.command, containerOptionsStatus.command) && Objects.equals(this.containerAdditionalOptions, containerOptionsStatus.containerAdditionalOptions) && Objects.equals(this.containerRuntime, containerOptionsStatus.containerRuntime) && Objects.equals(this.memoryMib, containerOptionsStatus.memoryMib) && Objects.equals(this.numCpuShares, containerOptionsStatus.numCpuShares) && Objects.equals(this.restartPolicy, containerOptionsStatus.restartPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.containerAdditionalOptions, this.containerRuntime, this.memoryMib, this.numCpuShares, this.restartPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerOptionsStatus {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    containerAdditionalOptions: ").append(this.toIndentedString(this.containerAdditionalOptions)).append("\n");
        sb.append("    containerRuntime: ").append(this.toIndentedString(this.containerRuntime)).append("\n");
        sb.append("    memoryMib: ").append(this.toIndentedString(this.memoryMib)).append("\n");
        sb.append("    numCpuShares: ").append(this.toIndentedString(this.numCpuShares)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

