/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Container;
import nutanix.model.ContainerDefStatus;
import nutanix.model.ContainerMetadata;

@ApiModel(description="Response object for intentful operations on a container")
public class ContainerIntentResource {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="metadata")
    private ContainerMetadata metadata = null;
    @SerializedName(value="spec")
    private Container spec = null;
    @SerializedName(value="status")
    private ContainerDefStatus status = null;

    public ContainerIntentResource apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ContainerIntentResource metadata(ContainerMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public ContainerMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ContainerMetadata metadata) {
        this.metadata = metadata;
    }

    public ContainerIntentResource spec(Container spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Container getSpec() {
        return this.spec;
    }

    public void setSpec(Container spec) {
        this.spec = spec;
    }

    public ContainerIntentResource status(ContainerDefStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ContainerDefStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContainerDefStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerIntentResource containerIntentResource = (ContainerIntentResource)o;
        return Objects.equals(this.apiVersion, containerIntentResource.apiVersion) && Objects.equals(this.metadata, containerIntentResource.metadata) && Objects.equals(this.spec, containerIntentResource.spec) && Objects.equals(this.status, containerIntentResource.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerIntentResource {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

