/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ClusterDomainServer;
import nutanix.model.ClusterNetworkEntity;
import nutanix.model.HttpProxyWhitelist;
import nutanix.model.SmtpServer;

@ApiModel(description="Cluster network.")
public class ClusterNetwork {
    @SerializedName(value="domain_server")
    private ClusterDomainServer domainServer = null;
    @SerializedName(value="external_data_services_ip")
    private String externalDataServicesIp = null;
    @SerializedName(value="external_ip")
    private String externalIp = null;
    @SerializedName(value="external_subnet")
    private String externalSubnet = "172.16.0.0/255.240.0.0";
    @SerializedName(value="http_proxy_list")
    private List<ClusterNetworkEntity> httpProxyList = new ArrayList<ClusterNetworkEntity>();
    @SerializedName(value="http_proxy_whitelist")
    private List<HttpProxyWhitelist> httpProxyWhitelist = new ArrayList<HttpProxyWhitelist>();
    @SerializedName(value="internal_subnet")
    private String internalSubnet = "192.168.5.0/255.255.255.0";
    @SerializedName(value="name_server_ip_list")
    private List<String> nameServerIpList = new ArrayList<String>();
    @SerializedName(value="nfs_subnet_whitelist")
    private List<String> nfsSubnetWhitelist = new ArrayList<String>();
    @SerializedName(value="ntp_server_ip_list")
    private List<String> ntpServerIpList = new ArrayList<String>();
    @SerializedName(value="smtp_server")
    private SmtpServer smtpServer = null;

    public ClusterNetwork domainServer(ClusterDomainServer domainServer) {
        this.domainServer = domainServer;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ClusterDomainServer getDomainServer() {
        return this.domainServer;
    }

    public void setDomainServer(ClusterDomainServer domainServer) {
        this.domainServer = domainServer;
    }

    public ClusterNetwork externalDataServicesIp(String externalDataServicesIp) {
        this.externalDataServicesIp = externalDataServicesIp;
        return this;
    }

    @ApiModelProperty(example="null", value="The cluster IP address that provides external entities access to various cluster data services. ")
    public String getExternalDataServicesIp() {
        return this.externalDataServicesIp;
    }

    public void setExternalDataServicesIp(String externalDataServicesIp) {
        this.externalDataServicesIp = externalDataServicesIp;
    }

    public ClusterNetwork externalIp(String externalIp) {
        this.externalIp = externalIp;
        return this;
    }

    @ApiModelProperty(example="null", value="The local IP of cluster visible externally.")
    public String getExternalIp() {
        return this.externalIp;
    }

    public void setExternalIp(String externalIp) {
        this.externalIp = externalIp;
    }

    public ClusterNetwork externalSubnet(String externalSubnet) {
        this.externalSubnet = externalSubnet;
        return this;
    }

    @ApiModelProperty(example="null", value="External subnet for cross server communication. The format is IP/netmask. ")
    public String getExternalSubnet() {
        return this.externalSubnet;
    }

    public void setExternalSubnet(String externalSubnet) {
        this.externalSubnet = externalSubnet;
    }

    public ClusterNetwork httpProxyList(List<ClusterNetworkEntity> httpProxyList) {
        this.httpProxyList = httpProxyList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of proxies to connect to the service centers.")
    public List<ClusterNetworkEntity> getHttpProxyList() {
        return this.httpProxyList;
    }

    public void setHttpProxyList(List<ClusterNetworkEntity> httpProxyList) {
        this.httpProxyList = httpProxyList;
    }

    public ClusterNetwork httpProxyWhitelist(List<HttpProxyWhitelist> httpProxyWhitelist) {
        this.httpProxyWhitelist = httpProxyWhitelist;
        return this;
    }

    @ApiModelProperty(example="null", value="List of HTTP proxy whitelist.")
    public List<HttpProxyWhitelist> getHttpProxyWhitelist() {
        return this.httpProxyWhitelist;
    }

    public void setHttpProxyWhitelist(List<HttpProxyWhitelist> httpProxyWhitelist) {
        this.httpProxyWhitelist = httpProxyWhitelist;
    }

    public ClusterNetwork internalSubnet(String internalSubnet) {
        this.internalSubnet = internalSubnet;
        return this;
    }

    @ApiModelProperty(example="null", value="The internal subnet is local to every server - its not visible outside.iSCSI requests generated internally within the appliance (by user VMs or VMFS) are sent to the internal subnet. The format is IP/netmask. ")
    public String getInternalSubnet() {
        return this.internalSubnet;
    }

    public void setInternalSubnet(String internalSubnet) {
        this.internalSubnet = internalSubnet;
    }

    public ClusterNetwork nameServerIpList(List<String> nameServerIpList) {
        this.nameServerIpList = nameServerIpList;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of IP addresses of the name servers.")
    public List<String> getNameServerIpList() {
        return this.nameServerIpList;
    }

    public void setNameServerIpList(List<String> nameServerIpList) {
        this.nameServerIpList = nameServerIpList;
    }

    public ClusterNetwork nfsSubnetWhitelist(List<String> nfsSubnetWhitelist) {
        this.nfsSubnetWhitelist = nfsSubnetWhitelist;
        return this;
    }

    @ApiModelProperty(example="null", value="Comma separated list of subnets (of the form 'a.b.c.d/l.m.n.o') that are allowed to send NFS requests to this container. If not specified, the global NFS whitelist will be looked up for access permission. The internal subnet is always automatically considered part of the whitelist, even if the field below does not explicitly specify it. Similarly, all the hypervisor IPs are considered part of the whitelist. Finally, to permit debugging, all of the SVMs local IPs are considered to be implicitly part of the whitelist. ")
    public List<String> getNfsSubnetWhitelist() {
        return this.nfsSubnetWhitelist;
    }

    public void setNfsSubnetWhitelist(List<String> nfsSubnetWhitelist) {
        this.nfsSubnetWhitelist = nfsSubnetWhitelist;
    }

    public ClusterNetwork ntpServerIpList(List<String> ntpServerIpList) {
        this.ntpServerIpList = ntpServerIpList;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of IP addresses or FQDNs of the NTP servers.")
    public List<String> getNtpServerIpList() {
        return this.ntpServerIpList;
    }

    public void setNtpServerIpList(List<String> ntpServerIpList) {
        this.ntpServerIpList = ntpServerIpList;
    }

    public ClusterNetwork smtpServer(SmtpServer smtpServer) {
        this.smtpServer = smtpServer;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public SmtpServer getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(SmtpServer smtpServer) {
        this.smtpServer = smtpServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNetwork clusterNetwork = (ClusterNetwork)o;
        return Objects.equals(this.domainServer, clusterNetwork.domainServer) && Objects.equals(this.externalDataServicesIp, clusterNetwork.externalDataServicesIp) && Objects.equals(this.externalIp, clusterNetwork.externalIp) && Objects.equals(this.externalSubnet, clusterNetwork.externalSubnet) && Objects.equals(this.httpProxyList, clusterNetwork.httpProxyList) && Objects.equals(this.httpProxyWhitelist, clusterNetwork.httpProxyWhitelist) && Objects.equals(this.internalSubnet, clusterNetwork.internalSubnet) && Objects.equals(this.nameServerIpList, clusterNetwork.nameServerIpList) && Objects.equals(this.nfsSubnetWhitelist, clusterNetwork.nfsSubnetWhitelist) && Objects.equals(this.ntpServerIpList, clusterNetwork.ntpServerIpList) && Objects.equals(this.smtpServer, clusterNetwork.smtpServer);
    }

    public int hashCode() {
        return Objects.hash(this.domainServer, this.externalDataServicesIp, this.externalIp, this.externalSubnet, this.httpProxyList, this.httpProxyWhitelist, this.internalSubnet, this.nameServerIpList, this.nfsSubnetWhitelist, this.ntpServerIpList, this.smtpServer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterNetwork {\n");
        sb.append("    domainServer: ").append(this.toIndentedString(this.domainServer)).append("\n");
        sb.append("    externalDataServicesIp: ").append(this.toIndentedString(this.externalDataServicesIp)).append("\n");
        sb.append("    externalIp: ").append(this.toIndentedString(this.externalIp)).append("\n");
        sb.append("    externalSubnet: ").append(this.toIndentedString(this.externalSubnet)).append("\n");
        sb.append("    httpProxyList: ").append(this.toIndentedString(this.httpProxyList)).append("\n");
        sb.append("    httpProxyWhitelist: ").append(this.toIndentedString(this.httpProxyWhitelist)).append("\n");
        sb.append("    internalSubnet: ").append(this.toIndentedString(this.internalSubnet)).append("\n");
        sb.append("    nameServerIpList: ").append(this.toIndentedString(this.nameServerIpList)).append("\n");
        sb.append("    nfsSubnetWhitelist: ").append(this.toIndentedString(this.nfsSubnetWhitelist)).append("\n");
        sb.append("    ntpServerIpList: ").append(this.toIndentedString(this.ntpServerIpList)).append("\n");
        sb.append("    smtpServer: ").append(this.toIndentedString(this.smtpServer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

