/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Credentials;

@ApiModel(description="Cluster domain server. Only applied to the cluster with all Hyper-V hosts. ")
public class ClusterDomainServer {
    @SerializedName(value="domain_credentials")
    private Credentials domainCredentials = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="nameserver")
    private String nameserver = null;

    public ClusterDomainServer domainCredentials(Credentials domainCredentials) {
        this.domainCredentials = domainCredentials;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Credentials getDomainCredentials() {
        return this.domainCredentials;
    }

    public void setDomainCredentials(Credentials domainCredentials) {
        this.domainCredentials = domainCredentials;
    }

    public ClusterDomainServer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Joined domain name. In 'put' request, empty name will unjoin the cluster from current domain. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterDomainServer nameserver(String nameserver) {
        this.nameserver = nameserver;
        return this;
    }

    @ApiModelProperty(example="null", value="The IP of the nameserver that can resolve the domain name. Must set when joining the domain. ")
    public String getNameserver() {
        return this.nameserver;
    }

    public void setNameserver(String nameserver) {
        this.nameserver = nameserver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDomainServer clusterDomainServer = (ClusterDomainServer)o;
        return Objects.equals(this.domainCredentials, clusterDomainServer.domainCredentials) && Objects.equals(this.name, clusterDomainServer.name) && Objects.equals(this.nameserver, clusterDomainServer.nameserver);
    }

    public int hashCode() {
        return Objects.hash(this.domainCredentials, this.name, this.nameserver);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterDomainServer {\n");
        sb.append("    domainCredentials: ").append(this.toIndentedString(this.domainCredentials)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameserver: ").append(this.toIndentedString(this.nameserver)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

