/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ClusterDefStatusResources;
import nutanix.model.MessageResource;

@ApiModel(description="Cluster status definition.  A Nutanix cluster is comprised of three or more Nutanix nodes. Each node in the cluster contains memory, CPU, RAM, and storage (SSD/HDD). Each node in the cluster runs standard hypervisor such as VMware vSphere, Microsoft Hyper-V, or AHV. A Controller VM (CVM) runs on each node in the cluster. The CVM enables each node to share local storage from all nodes in the cluster. ")
public class ClusterDefStatus {
    @SerializedName(value="message_list")
    private List<MessageResource> messageList = new ArrayList<MessageResource>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resources")
    private ClusterDefStatusResources resources = null;
    @SerializedName(value="state")
    private String state = null;

    public ClusterDefStatus messageList(List<MessageResource> messageList) {
        this.messageList = messageList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<MessageResource> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<MessageResource> messageList) {
        this.messageList = messageList;
    }

    public ClusterDefStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Cluster name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterDefStatus resources(ClusterDefStatusResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ClusterDefStatusResources getResources() {
        return this.resources;
    }

    public void setResources(ClusterDefStatusResources resources) {
        this.resources = resources;
    }

    @ApiModelProperty(example="null", value="The state of the cluster entity.")
    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDefStatus clusterDefStatus = (ClusterDefStatus)o;
        return Objects.equals(this.messageList, clusterDefStatus.messageList) && Objects.equals(this.name, clusterDefStatus.name) && Objects.equals(this.resources, clusterDefStatus.resources) && Objects.equals(this.state, clusterDefStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.messageList, this.name, this.resources, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterDefStatus {\n");
        sb.append("    messageList: ").append(this.toIndentedString(this.messageList)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

