/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nutanix.model.CertificationSigningInfo;
import nutanix.model.ClientAuth;
import nutanix.model.ClusterSoftware;
import nutanix.model.PublicKey;

@ApiModel(description="Cluster Configuration.")
public class ClusterConfigSpec {
    @SerializedName(value="authorized_public_key_list")
    private List<PublicKey> authorizedPublicKeyList = new ArrayList<PublicKey>();
    @SerializedName(value="certification_signing_info")
    private CertificationSigningInfo certificationSigningInfo = null;
    @SerializedName(value="client_auth")
    private ClientAuth clientAuth = null;
    @SerializedName(value="enabled_feature_list")
    private List<String> enabledFeatureList = new ArrayList<String>();
    @SerializedName(value="encryption_status")
    private String encryptionStatus = "NOT_SUPPORTED";
    @SerializedName(value="redundancy_factor")
    private Integer redundancyFactor = null;
    @SerializedName(value="software_map")
    private Map<String, ClusterSoftware> softwareMap = new HashMap<String, ClusterSoftware>();
    @SerializedName(value="supported_information_verbosity")
    private String supportedInformationVerbosity = "BASIC_PLUS_CORE_DUMP";
    @SerializedName(value="timezone")
    private String timezone = null;

    public ClusterConfigSpec authorizedPublicKeyList(List<PublicKey> authorizedPublicKeyList) {
        this.authorizedPublicKeyList = authorizedPublicKeyList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of valid ssh keys for the cluster.")
    public List<PublicKey> getAuthorizedPublicKeyList() {
        return this.authorizedPublicKeyList;
    }

    public void setAuthorizedPublicKeyList(List<PublicKey> authorizedPublicKeyList) {
        this.authorizedPublicKeyList = authorizedPublicKeyList;
    }

    public ClusterConfigSpec certificationSigningInfo(CertificationSigningInfo certificationSigningInfo) {
        this.certificationSigningInfo = certificationSigningInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CertificationSigningInfo getCertificationSigningInfo() {
        return this.certificationSigningInfo;
    }

    public void setCertificationSigningInfo(CertificationSigningInfo certificationSigningInfo) {
        this.certificationSigningInfo = certificationSigningInfo;
    }

    public ClusterConfigSpec clientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    public ClusterConfigSpec enabledFeatureList(List<String> enabledFeatureList) {
        this.enabledFeatureList = enabledFeatureList;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of enabled features.")
    public List<String> getEnabledFeatureList() {
        return this.enabledFeatureList;
    }

    public void setEnabledFeatureList(List<String> enabledFeatureList) {
        this.enabledFeatureList = enabledFeatureList;
    }

    public ClusterConfigSpec encryptionStatus(String encryptionStatus) {
        this.encryptionStatus = encryptionStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Cluster encryption status.")
    public String getEncryptionStatus() {
        return this.encryptionStatus;
    }

    public void setEncryptionStatus(String encryptionStatus) {
        this.encryptionStatus = encryptionStatus;
    }

    public ClusterConfigSpec redundancyFactor(Integer redundancyFactor) {
        this.redundancyFactor = redundancyFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="Cluster supported redundancy factor. Default is 2.")
    public Integer getRedundancyFactor() {
        return this.redundancyFactor;
    }

    public void setRedundancyFactor(Integer redundancyFactor) {
        this.redundancyFactor = redundancyFactor;
    }

    public ClusterConfigSpec softwareMap(Map<String, ClusterSoftware> softwareMap) {
        this.softwareMap = softwareMap;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of software on the cluster with software type as the key. ")
    public Map<String, ClusterSoftware> getSoftwareMap() {
        return this.softwareMap;
    }

    public void setSoftwareMap(Map<String, ClusterSoftware> softwareMap) {
        this.softwareMap = softwareMap;
    }

    public ClusterConfigSpec supportedInformationVerbosity(String supportedInformationVerbosity) {
        this.supportedInformationVerbosity = supportedInformationVerbosity;
        return this;
    }

    @ApiModelProperty(example="null", value="Verbosity level settings for populating support information. - 'Nothing': Send nothing - 'Basic': Send basic information - skip core dump and hypervisor            stats information - 'BasicPlusCoreDump': Send basic and core dump information - 'All': Send all information ")
    public String getSupportedInformationVerbosity() {
        return this.supportedInformationVerbosity;
    }

    public void setSupportedInformationVerbosity(String supportedInformationVerbosity) {
        this.supportedInformationVerbosity = supportedInformationVerbosity;
    }

    public ClusterConfigSpec timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(example="null", value="Zone name used in value of TZ environment variable.")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConfigSpec clusterConfigSpec = (ClusterConfigSpec)o;
        return Objects.equals(this.authorizedPublicKeyList, clusterConfigSpec.authorizedPublicKeyList) && Objects.equals(this.certificationSigningInfo, clusterConfigSpec.certificationSigningInfo) && Objects.equals(this.clientAuth, clusterConfigSpec.clientAuth) && Objects.equals(this.enabledFeatureList, clusterConfigSpec.enabledFeatureList) && Objects.equals(this.encryptionStatus, clusterConfigSpec.encryptionStatus) && Objects.equals(this.redundancyFactor, clusterConfigSpec.redundancyFactor) && Objects.equals(this.softwareMap, clusterConfigSpec.softwareMap) && Objects.equals(this.supportedInformationVerbosity, clusterConfigSpec.supportedInformationVerbosity) && Objects.equals(this.timezone, clusterConfigSpec.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedPublicKeyList, this.certificationSigningInfo, this.clientAuth, this.enabledFeatureList, this.encryptionStatus, this.redundancyFactor, this.softwareMap, this.supportedInformationVerbosity, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterConfigSpec {\n");
        sb.append("    authorizedPublicKeyList: ").append(this.toIndentedString(this.authorizedPublicKeyList)).append("\n");
        sb.append("    certificationSigningInfo: ").append(this.toIndentedString(this.certificationSigningInfo)).append("\n");
        sb.append("    clientAuth: ").append(this.toIndentedString(this.clientAuth)).append("\n");
        sb.append("    enabledFeatureList: ").append(this.toIndentedString(this.enabledFeatureList)).append("\n");
        sb.append("    encryptionStatus: ").append(this.toIndentedString(this.encryptionStatus)).append("\n");
        sb.append("    redundancyFactor: ").append(this.toIndentedString(this.redundancyFactor)).append("\n");
        sb.append("    softwareMap: ").append(this.toIndentedString(this.softwareMap)).append("\n");
        sb.append("    supportedInformationVerbosity: ").append(this.toIndentedString(this.supportedInformationVerbosity)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

