/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nutanix.model.BuildInfo;
import nutanix.model.CaCert;
import nutanix.model.CertificationSigningInfo;
import nutanix.model.ClientAuth;
import nutanix.model.ClusterSoftware;
import nutanix.model.PublicKey;
import nutanix.model.SslKey;

@ApiModel(description="Cluster Configuration.")
public class ClusterConfig {
    @SerializedName(value="authorized_public_key_list")
    private List<PublicKey> authorizedPublicKeyList = new ArrayList<PublicKey>();
    @SerializedName(value="build")
    private BuildInfo build = null;
    @SerializedName(value="ca_certificate_list")
    private List<CaCert> caCertificateList = new ArrayList<CaCert>();
    @SerializedName(value="certification_signing_info")
    private CertificationSigningInfo certificationSigningInfo = null;
    @SerializedName(value="client_auth")
    private ClientAuth clientAuth = null;
    @SerializedName(value="enabled_feature_list")
    private List<String> enabledFeatureList = new ArrayList<String>();
    @SerializedName(value="encryption_status")
    private String encryptionStatus = "NOT_SUPPORTED";
    @SerializedName(value="redundancy_factor")
    private Integer redundancyFactor = null;
    @SerializedName(value="service_list")
    private List<String> serviceList = new ArrayList<String>();
    @SerializedName(value="software_map")
    private Map<String, ClusterSoftware> softwareMap = new HashMap<String, ClusterSoftware>();
    @SerializedName(value="ssl_key")
    private SslKey sslKey = null;
    @SerializedName(value="supported_information_verbosity")
    private String supportedInformationVerbosity = "BASIC_PLUS_CORE_DUMP";
    @SerializedName(value="timezone")
    private String timezone = null;

    public ClusterConfig authorizedPublicKeyList(List<PublicKey> authorizedPublicKeyList) {
        this.authorizedPublicKeyList = authorizedPublicKeyList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of valid ssh keys for the cluster.")
    public List<PublicKey> getAuthorizedPublicKeyList() {
        return this.authorizedPublicKeyList;
    }

    public void setAuthorizedPublicKeyList(List<PublicKey> authorizedPublicKeyList) {
        this.authorizedPublicKeyList = authorizedPublicKeyList;
    }

    public ClusterConfig build(BuildInfo build) {
        this.build = build;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public BuildInfo getBuild() {
        return this.build;
    }

    public void setBuild(BuildInfo build) {
        this.build = build;
    }

    public ClusterConfig caCertificateList(List<CaCert> caCertificateList) {
        this.caCertificateList = caCertificateList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of cluster trusted CA certificates.")
    public List<CaCert> getCaCertificateList() {
        return this.caCertificateList;
    }

    public void setCaCertificateList(List<CaCert> caCertificateList) {
        this.caCertificateList = caCertificateList;
    }

    public ClusterConfig certificationSigningInfo(CertificationSigningInfo certificationSigningInfo) {
        this.certificationSigningInfo = certificationSigningInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CertificationSigningInfo getCertificationSigningInfo() {
        return this.certificationSigningInfo;
    }

    public void setCertificationSigningInfo(CertificationSigningInfo certificationSigningInfo) {
        this.certificationSigningInfo = certificationSigningInfo;
    }

    public ClusterConfig clientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    public ClusterConfig enabledFeatureList(List<String> enabledFeatureList) {
        this.enabledFeatureList = enabledFeatureList;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of enabled features.")
    public List<String> getEnabledFeatureList() {
        return this.enabledFeatureList;
    }

    public void setEnabledFeatureList(List<String> enabledFeatureList) {
        this.enabledFeatureList = enabledFeatureList;
    }

    public ClusterConfig encryptionStatus(String encryptionStatus) {
        this.encryptionStatus = encryptionStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Cluster encryption status.")
    public String getEncryptionStatus() {
        return this.encryptionStatus;
    }

    public void setEncryptionStatus(String encryptionStatus) {
        this.encryptionStatus = encryptionStatus;
    }

    public ClusterConfig redundancyFactor(Integer redundancyFactor) {
        this.redundancyFactor = redundancyFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="Cluster supported redundancy factor.")
    public Integer getRedundancyFactor() {
        return this.redundancyFactor;
    }

    public void setRedundancyFactor(Integer redundancyFactor) {
        this.redundancyFactor = redundancyFactor;
    }

    public ClusterConfig serviceList(List<String> serviceList) {
        this.serviceList = serviceList;
        return this;
    }

    @ApiModelProperty(example="null", value="Array of enabled cluster services. For example, a cluster can function as both AOS and cloud data gateway. - AOS: Regular Prism Element - PRISM_CENTRAL: Prism Central - CLOUD_DATA_GATEWAY: Cloud backup and DR gateway - AFS: Cluster for file server - WITNESS : Witness cluster - XI_PORTAL: Xi cluster ")
    public List<String> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<String> serviceList) {
        this.serviceList = serviceList;
    }

    public ClusterConfig softwareMap(Map<String, ClusterSoftware> softwareMap) {
        this.softwareMap = softwareMap;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of software on the cluster with software type as the key. ")
    public Map<String, ClusterSoftware> getSoftwareMap() {
        return this.softwareMap;
    }

    public void setSoftwareMap(Map<String, ClusterSoftware> softwareMap) {
        this.softwareMap = softwareMap;
    }

    public ClusterConfig sslKey(SslKey sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public SslKey getSslKey() {
        return this.sslKey;
    }

    public void setSslKey(SslKey sslKey) {
        this.sslKey = sslKey;
    }

    public ClusterConfig supportedInformationVerbosity(String supportedInformationVerbosity) {
        this.supportedInformationVerbosity = supportedInformationVerbosity;
        return this;
    }

    @ApiModelProperty(example="null", value="Verbosity level settings for populating support information. - 'Nothing': Send nothing - 'Basic': Send basic information - skip core dump and hypervisor            stats information - 'BasicPlusCoreDump': Send basic and core dump information - 'All': Send all information ")
    public String getSupportedInformationVerbosity() {
        return this.supportedInformationVerbosity;
    }

    public void setSupportedInformationVerbosity(String supportedInformationVerbosity) {
        this.supportedInformationVerbosity = supportedInformationVerbosity;
    }

    public ClusterConfig timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(example="null", value="Zone name used in value of TZ environment variable.")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConfig clusterConfig = (ClusterConfig)o;
        return Objects.equals(this.authorizedPublicKeyList, clusterConfig.authorizedPublicKeyList) && Objects.equals(this.build, clusterConfig.build) && Objects.equals(this.caCertificateList, clusterConfig.caCertificateList) && Objects.equals(this.certificationSigningInfo, clusterConfig.certificationSigningInfo) && Objects.equals(this.clientAuth, clusterConfig.clientAuth) && Objects.equals(this.enabledFeatureList, clusterConfig.enabledFeatureList) && Objects.equals(this.encryptionStatus, clusterConfig.encryptionStatus) && Objects.equals(this.redundancyFactor, clusterConfig.redundancyFactor) && Objects.equals(this.serviceList, clusterConfig.serviceList) && Objects.equals(this.softwareMap, clusterConfig.softwareMap) && Objects.equals(this.sslKey, clusterConfig.sslKey) && Objects.equals(this.supportedInformationVerbosity, clusterConfig.supportedInformationVerbosity) && Objects.equals(this.timezone, clusterConfig.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedPublicKeyList, this.build, this.caCertificateList, this.certificationSigningInfo, this.clientAuth, this.enabledFeatureList, this.encryptionStatus, this.redundancyFactor, this.serviceList, this.softwareMap, this.sslKey, this.supportedInformationVerbosity, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterConfig {\n");
        sb.append("    authorizedPublicKeyList: ").append(this.toIndentedString(this.authorizedPublicKeyList)).append("\n");
        sb.append("    build: ").append(this.toIndentedString(this.build)).append("\n");
        sb.append("    caCertificateList: ").append(this.toIndentedString(this.caCertificateList)).append("\n");
        sb.append("    certificationSigningInfo: ").append(this.toIndentedString(this.certificationSigningInfo)).append("\n");
        sb.append("    clientAuth: ").append(this.toIndentedString(this.clientAuth)).append("\n");
        sb.append("    enabledFeatureList: ").append(this.toIndentedString(this.enabledFeatureList)).append("\n");
        sb.append("    encryptionStatus: ").append(this.toIndentedString(this.encryptionStatus)).append("\n");
        sb.append("    redundancyFactor: ").append(this.toIndentedString(this.redundancyFactor)).append("\n");
        sb.append("    serviceList: ").append(this.toIndentedString(this.serviceList)).append("\n");
        sb.append("    softwareMap: ").append(this.toIndentedString(this.softwareMap)).append("\n");
        sb.append("    sslKey: ").append(this.toIndentedString(this.sslKey)).append("\n");
        sb.append("    supportedInformationVerbosity: ").append(this.toIndentedString(this.supportedInformationVerbosity)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

