/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.MessageResource;

@ApiModel(description="The status of a REST API call; only used when there is a failure to report. ")
public class CloudCredentialsStatus {
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="code")
    private Integer code = null;
    @SerializedName(value="kind")
    private String kind = "cloud_credentials";
    @SerializedName(value="message_list")
    private List<MessageResource> messageList = new ArrayList<MessageResource>();
    @SerializedName(value="state")
    private String state = null;

    @ApiModelProperty(example="null", value="")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @ApiModelProperty(example="null", value="The HTTP error code")
    public Integer getCode() {
        return this.code;
    }

    @ApiModelProperty(example="null", value="The kind name")
    public String getKind() {
        return this.kind;
    }

    public CloudCredentialsStatus messageList(List<MessageResource> messageList) {
        this.messageList = messageList;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<MessageResource> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<MessageResource> messageList) {
        this.messageList = messageList;
    }

    @ApiModelProperty(example="null", value="")
    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudCredentialsStatus cloudCredentialsStatus = (CloudCredentialsStatus)o;
        return Objects.equals(this.apiVersion, cloudCredentialsStatus.apiVersion) && Objects.equals(this.code, cloudCredentialsStatus.code) && Objects.equals(this.kind, cloudCredentialsStatus.kind) && Objects.equals(this.messageList, cloudCredentialsStatus.messageList) && Objects.equals(this.state, cloudCredentialsStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.code, this.kind, this.messageList, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudCredentialsStatus {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    messageList: ").append(this.toIndentedString(this.messageList)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

