/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Client authentication config.")
public class ClientAuth {
    @SerializedName(value="ca_chain")
    private byte[] caChain = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="status")
    private String status = "DISABLED";

    @ApiModelProperty(example="null", value="Content of CA chain certificate.")
    public byte[] getCaChain() {
        return this.caChain;
    }

    @ApiModelProperty(example="null", value="Name of CA chain file.")
    public String getName() {
        return this.name;
    }

    public ClientAuth status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Status of client authentication.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientAuth clientAuth = (ClientAuth)o;
        return Objects.equals(this.caChain, clientAuth.caChain) && Objects.equals(this.name, clientAuth.name) && Objects.equals(this.status, clientAuth.status);
    }

    public int hashCode() {
        return Objects.hash(this.caChain, this.name, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientAuth {\n");
        sb.append("    caChain: ").append(this.toIndentedString(this.caChain)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

