/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Input for the changed regions query. ")
public class ChangedRegionsQuery {
    @SerializedName(value="end_offset")
    private Long endOffset = null;
    @SerializedName(value="reference_snapshot_file_path")
    private String referenceSnapshotFilePath = null;
    @SerializedName(value="snapshot_file_path")
    private String snapshotFilePath = null;
    @SerializedName(value="start_offset")
    private Long startOffset = 0L;

    public ChangedRegionsQuery endOffset(Long endOffset) {
        this.endOffset = endOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="The absolute offset in bytes up to which to query for the changed regions. Note that the interval specified by the start_offset together with the end_offset is right half-open. If the end_offset is not specified, the portion from the start_offset till the end of the file will be included in the query. ")
    public Long getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(Long endOffset) {
        this.endOffset = endOffset;
    }

    public ChangedRegionsQuery referenceSnapshotFilePath(String referenceSnapshotFilePath) {
        this.referenceSnapshotFilePath = referenceSnapshotFilePath;
        return this;
    }

    @ApiModelProperty(example="null", value="Absolute path of a file within a snapshot that must be used as the reference in the computation of the changed regions. If this path is not specified, then the changed regions will not be computed. Instead, the sparse and the non-sparse regions of the file specified in snapshot_file_path will be returned. ")
    public String getReferenceSnapshotFilePath() {
        return this.referenceSnapshotFilePath;
    }

    public void setReferenceSnapshotFilePath(String referenceSnapshotFilePath) {
        this.referenceSnapshotFilePath = referenceSnapshotFilePath;
    }

    public ChangedRegionsQuery snapshotFilePath(String snapshotFilePath) {
        this.snapshotFilePath = snapshotFilePath;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Absolute path of a file within a snapshot of an entity such as a virtual machine, a volume group, or a protection domain. ")
    public String getSnapshotFilePath() {
        return this.snapshotFilePath;
    }

    public void setSnapshotFilePath(String snapshotFilePath) {
        this.snapshotFilePath = snapshotFilePath;
    }

    public ChangedRegionsQuery startOffset(Long startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="The absolute offset in bytes from where to query for the changed regions. ")
    public Long getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(Long startOffset) {
        this.startOffset = startOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedRegionsQuery changedRegionsQuery = (ChangedRegionsQuery)o;
        return Objects.equals(this.endOffset, changedRegionsQuery.endOffset) && Objects.equals(this.referenceSnapshotFilePath, changedRegionsQuery.referenceSnapshotFilePath) && Objects.equals(this.snapshotFilePath, changedRegionsQuery.snapshotFilePath) && Objects.equals(this.startOffset, changedRegionsQuery.startOffset);
    }

    public int hashCode() {
        return Objects.hash(this.endOffset, this.referenceSnapshotFilePath, this.snapshotFilePath, this.startOffset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangedRegionsQuery {\n");
        sb.append("    endOffset: ").append(this.toIndentedString(this.endOffset)).append("\n");
        sb.append("    referenceSnapshotFilePath: ").append(this.toIndentedString(this.referenceSnapshotFilePath)).append("\n");
        sb.append("    snapshotFilePath: ").append(this.toIndentedString(this.snapshotFilePath)).append("\n");
        sb.append("    startOffset: ").append(this.toIndentedString(this.startOffset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

